/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.BTHeaderRec;
import org.catacombae.hfsexplorer.types.hfsplus.BTLeafNode;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfsx.HFSXCatalogLeafRecord;

public class HFSPlusCatalogLeafNode
extends BTLeafNode {
    protected HFSPlusCatalogLeafRecord[] leafRecords;

    public HFSPlusCatalogLeafNode(byte[] data, int offset, int nodeSize) {
        this(data, offset, nodeSize, null);
    }

    protected HFSPlusCatalogLeafNode(byte[] data, int offset, int nodeSize, BTHeaderRec catalogHeaderRec) {
        super(data, offset, nodeSize);
        int i;
        short[] offsets = new short[Util.unsign(this.nodeDescriptor.getNumRecords()) + 1];
        for (i = 0; i < offsets.length; ++i) {
            offsets[i] = Util.readShortBE(data, offset + nodeSize - (i + 1) * 2);
        }
        this.leafRecords = new HFSPlusCatalogLeafRecord[offsets.length - 1];
        for (i = 0; i < this.leafRecords.length; ++i) {
            int currentOffset = Util.unsign(offsets[i]);
            this.leafRecords[i] = catalogHeaderRec == null ? new HFSPlusCatalogLeafRecord(data, offset + currentOffset) : new HFSXCatalogLeafRecord(data, offset + currentOffset, catalogHeaderRec);
        }
    }

    public HFSPlusCatalogLeafRecord getLeafRecord(int index) {
        return this.leafRecords[index];
    }

    public HFSPlusCatalogLeafRecord[] getLeafRecords() {
        HFSPlusCatalogLeafRecord[] copy = new HFSPlusCatalogLeafRecord[this.leafRecords.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.leafRecords[i];
        }
        return copy;
    }
}

