# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AttestationCertificateManagementBody(_Model):
    """The body of the JWT used for the PolicyCertificates APIs.

    :ivar policy_certificate: RFC 7517 Json Web Key describing the certificate.
    :vartype policy_certificate: ~azure.security.attestation.models.JsonWebKey
    """

    policy_certificate: Optional["_models.JsonWebKey"] = rest_field(
        name="policyCertificate", visibility=["read", "create", "update", "delete", "query"]
    )
    """RFC 7517 Json Web Key describing the certificate."""

    @overload
    def __init__(
        self,
        *,
        policy_certificate: Optional["_models.JsonWebKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AttestationResponse(_Model):
    """The result of an attestation operation.

    :ivar token: An RFC 7519 JSON Web Token, the body of which is an AttestationResult object.
    :vartype token: str
    """

    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An RFC 7519 JSON Web Token, the body of which is an AttestationResult object."""

    @overload
    def __init__(
        self,
        *,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AttestationResult(_Model):
    """A Microsoft Azure Attestation response token body - the body of a response
    token issued by MAA.

        :ivar jti: Unique Identifier for the token.
        :vartype jti: str
        :ivar iss: The Principal who issued the token.
        :vartype iss: str
        :ivar iat: The time at which the token was issued, in the number of seconds since
     1970-01-0T00:00:00Z UTC.
        :vartype iat: float
        :ivar exp: The expiration time after which the token is no longer valid, in the number of
     seconds since 1970-01-0T00:00:00Z UTC.
        :vartype exp: float
        :ivar nbf: The not before time before which the token cannot be considered valid, in the
     number of seconds since 1970-01-0T00:00:00Z UTC.
        :vartype nbf: float
        :ivar cnf: An RFC 7800 Proof of Possession Key.
        :vartype cnf: dict[str, str]
        :ivar nonce: The Nonce input to the attestation request, if provided.
        :vartype nonce: str
        :ivar version: The Schema version of this structure. Current Value: 1.0.
        :vartype version: str
        :ivar runtime_claims: Runtime Claims.
        :vartype runtime_claims: dict[str, str]
        :ivar inittime_claims: Inittime Claims.
        :vartype inittime_claims: dict[str, str]
        :ivar policy_claims: Policy Generated Claims.
        :vartype policy_claims: dict[str, str]
        :ivar verifier_type: The Attestation type being attested.
        :vartype verifier_type: str
        :ivar policy_signer: The certificate used to sign the policy object, if specified.
        :vartype policy_signer: ~azure.security.attestation.models.JsonWebKey
        :ivar policy_hash: The SHA256 hash of the BASE64URL encoded policy text used for attestation.
        :vartype policy_hash: bytes
        :ivar is_debuggable: True if the enclave is debuggable, false otherwise.
        :vartype is_debuggable: bool
        :ivar product_id: The SGX Product ID for the enclave.
        :vartype product_id: float
        :ivar mr_enclave: The HEX encoded SGX MRENCLAVE value for the enclave.
        :vartype mr_enclave: str
        :ivar mr_signer: The HEX encoded SGX MRSIGNER value for the enclave.
        :vartype mr_signer: str
        :ivar svn: The SGX SVN value for the enclave.
        :vartype svn: float
        :ivar enclave_held_data: A copy of the RuntimeData specified as an input to the attest call.
        :vartype enclave_held_data: bytes
        :ivar sgx_collateral: The SGX SVN value for the enclave.
        :vartype sgx_collateral: dict[str, str]
        :ivar deprecated_version: DEPRECATED: Private Preview version of x-ms-ver claim.
        :vartype deprecated_version: str
        :ivar deprecated_is_debuggable: DEPRECATED: Private Preview version of x-ms-sgx-is-debuggable
         claim.
        :vartype deprecated_is_debuggable: bool
        :ivar deprecated_sgx_collateral: DEPRECATED: Private Preview version of x-ms-sgx-collateral
         claim.
        :vartype deprecated_sgx_collateral: dict[str, str]
        :ivar deprecated_enclave_held_data: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
        :vartype deprecated_enclave_held_data: bytes
        :ivar deprecated_enclave_held_data2: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
        :vartype deprecated_enclave_held_data2: bytes
        :ivar deprecated_product_id: DEPRECATED: Private Preview version of x-ms-sgx-product-id.
        :vartype deprecated_product_id: float
        :ivar deprecated_mr_enclave: DEPRECATED: Private Preview version of x-ms-sgx-mrenclave.
        :vartype deprecated_mr_enclave: str
        :ivar deprecated_mr_signer: DEPRECATED: Private Preview version of x-ms-sgx-mrsigner.
        :vartype deprecated_mr_signer: str
        :ivar deprecated_svn: DEPRECATED: Private Preview version of x-ms-sgx-svn.
        :vartype deprecated_svn: float
        :ivar deprecated_tee: DEPRECATED: Private Preview version of x-ms-tee.
        :vartype deprecated_tee: str
        :ivar deprecated_policy_signer: DEPRECATED: Private Preview version of x-ms-policy-signer.
        :vartype deprecated_policy_signer: ~azure.security.attestation.models.JsonWebKey
        :ivar deprecated_policy_hash: DEPRECATED: Private Preview version of x-ms-policy-hash.
        :vartype deprecated_policy_hash: bytes
        :ivar deprecated_rp_data: DEPRECATED: Private Preview version of nonce.
        :vartype deprecated_rp_data: str
    """

    jti: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique Identifier for the token."""
    iss: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Principal who issued the token."""
    iat: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The time at which the token was issued, in the number of seconds since
 1970-01-0T00:00:00Z UTC."""
    exp: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The expiration time after which the token is no longer valid, in the number of
 seconds since 1970-01-0T00:00:00Z UTC."""
    nbf: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The not before time before which the token cannot be considered valid, in the
 number of seconds since 1970-01-0T00:00:00Z UTC."""
    cnf: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An RFC 7800 Proof of Possession Key."""
    nonce: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Nonce input to the attestation request, if provided."""
    version: Optional[str] = rest_field(name="x-ms-ver", visibility=["read", "create", "update", "delete", "query"])
    """The Schema version of this structure. Current Value: 1.0."""
    runtime_claims: Optional[dict[str, str]] = rest_field(
        name="x-ms-runtime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Runtime Claims."""
    inittime_claims: Optional[dict[str, str]] = rest_field(
        name="x-ms-inittime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Inittime Claims."""
    policy_claims: Optional[dict[str, str]] = rest_field(
        name="x-ms-policy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy Generated Claims."""
    verifier_type: Optional[str] = rest_field(
        name="x-ms-attestation-type", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Attestation type being attested."""
    policy_signer: Optional["_models.JsonWebKey"] = rest_field(
        name="x-ms-policy-signer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The certificate used to sign the policy object, if specified."""
    policy_hash: Optional[bytes] = rest_field(
        name="x-ms-policy-hash", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """The SHA256 hash of the BASE64URL encoded policy text used for attestation."""
    is_debuggable: Optional[bool] = rest_field(
        name="x-ms-sgx-is-debuggable", visibility=["read", "create", "update", "delete", "query"]
    )
    """True if the enclave is debuggable, false otherwise."""
    product_id: Optional[float] = rest_field(
        name="x-ms-sgx-product-id", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SGX Product ID for the enclave."""
    mr_enclave: Optional[str] = rest_field(
        name="x-ms-sgx-mrenclave", visibility=["read", "create", "update", "delete", "query"]
    )
    """The HEX encoded SGX MRENCLAVE value for the enclave."""
    mr_signer: Optional[str] = rest_field(
        name="x-ms-sgx-mrsigner", visibility=["read", "create", "update", "delete", "query"]
    )
    """The HEX encoded SGX MRSIGNER value for the enclave."""
    svn: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SGX SVN value for the enclave."""
    enclave_held_data: Optional[bytes] = rest_field(
        name="x-ms-sgx-ehd", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """A copy of the RuntimeData specified as an input to the attest call."""
    sgx_collateral: Optional[dict[str, str]] = rest_field(
        name="x-ms-sgx-collateral", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SGX SVN value for the enclave."""
    deprecated_version: Optional[str] = rest_field(
        name="ver", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-ver claim."""
    deprecated_is_debuggable: Optional[bool] = rest_field(
        name="is-debuggable", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-is-debuggable claim."""
    deprecated_sgx_collateral: Optional[dict[str, str]] = rest_field(
        name="maa-attestationcollateral", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-collateral claim."""
    deprecated_enclave_held_data: Optional[bytes] = rest_field(
        name="aas-ehd", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-ehd claim."""
    deprecated_enclave_held_data2: Optional[bytes] = rest_field(
        name="maa-ehd", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-ehd claim."""
    deprecated_product_id: Optional[float] = rest_field(
        name="product-id", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-product-id."""
    deprecated_mr_enclave: Optional[str] = rest_field(
        name="sgx-mrenclave", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-mrenclave."""
    deprecated_mr_signer: Optional[str] = rest_field(
        name="sgx-mrsigner", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-mrsigner."""
    deprecated_svn: Optional[float] = rest_field(
        name="deprecatedSvn", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-sgx-svn."""
    deprecated_tee: Optional[str] = rest_field(name="tee", visibility=["read", "create", "update", "delete", "query"])
    """DEPRECATED: Private Preview version of x-ms-tee."""
    deprecated_policy_signer: Optional["_models.JsonWebKey"] = rest_field(
        name="policy_signer", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of x-ms-policy-signer."""
    deprecated_policy_hash: Optional[bytes] = rest_field(
        name="policy_hash", visibility=["read", "create", "update", "delete", "query"], format="base64"
    )
    """DEPRECATED: Private Preview version of x-ms-policy-hash."""
    deprecated_rp_data: Optional[str] = rest_field(
        name="rp_data", visibility=["read", "create", "update", "delete", "query"]
    )
    """DEPRECATED: Private Preview version of nonce."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        jti: Optional[str] = None,
        iss: Optional[str] = None,
        iat: Optional[float] = None,
        exp: Optional[float] = None,
        nbf: Optional[float] = None,
        cnf: Optional[dict[str, str]] = None,
        nonce: Optional[str] = None,
        version: Optional[str] = None,
        runtime_claims: Optional[dict[str, str]] = None,
        inittime_claims: Optional[dict[str, str]] = None,
        policy_claims: Optional[dict[str, str]] = None,
        verifier_type: Optional[str] = None,
        policy_signer: Optional["_models.JsonWebKey"] = None,
        policy_hash: Optional[bytes] = None,
        is_debuggable: Optional[bool] = None,
        product_id: Optional[float] = None,
        mr_enclave: Optional[str] = None,
        mr_signer: Optional[str] = None,
        svn: Optional[float] = None,
        enclave_held_data: Optional[bytes] = None,
        sgx_collateral: Optional[dict[str, str]] = None,
        deprecated_version: Optional[str] = None,
        deprecated_is_debuggable: Optional[bool] = None,
        deprecated_sgx_collateral: Optional[dict[str, str]] = None,
        deprecated_enclave_held_data: Optional[bytes] = None,
        deprecated_enclave_held_data2: Optional[bytes] = None,
        deprecated_product_id: Optional[float] = None,
        deprecated_mr_enclave: Optional[str] = None,
        deprecated_mr_signer: Optional[str] = None,
        deprecated_svn: Optional[float] = None,
        deprecated_tee: Optional[str] = None,
        deprecated_policy_signer: Optional["_models.JsonWebKey"] = None,
        deprecated_policy_hash: Optional[bytes] = None,
        deprecated_rp_data: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AttestOpenEnclaveRequest(_Model):
    """Attestation request for Intel SGX enclaves.

    :ivar report: OpenEnclave report from the enclave to be attested.
    :vartype report: bytes
    :ivar runtime_data: Runtime data provided by the enclave at the time of report generation. The
     MAA will verify that the first 32 bytes of the report_data field of the quote
     contains the SHA256 hash of the decoded "data" field of the runtime data.
    :vartype runtime_data: ~azure.security.attestation.models.RuntimeData
    :ivar init_time_data: Base64Url encoded InitTime data.
    :vartype init_time_data: ~azure.security.attestation.models.InitTimeData
    :ivar draft_policy_for_attestation: Attest against the provided draft policy. Note that the
     resulting token cannot be validated.
    :vartype draft_policy_for_attestation: str
    :ivar nonce: Nonce for incoming request - emitted in the generated attestation token.
    :vartype nonce: str
    """

    report: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """OpenEnclave report from the enclave to be attested."""
    runtime_data: Optional["_models.RuntimeData"] = rest_field(
        name="runtimeData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Runtime data provided by the enclave at the time of report generation. The MAA
 will verify that the first 32 bytes of the report_data field of the quote
 contains the SHA256 hash of the decoded \"data\" field of the runtime data."""
    init_time_data: Optional["_models.InitTimeData"] = rest_field(
        name="initTimeData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64Url encoded \"InitTime data\". The MAA will verify that the init data was
 known to the enclave. Note that InitTimeData is invalid for CoffeeLake
 processors."""
    draft_policy_for_attestation: Optional[str] = rest_field(
        name="draftPolicyForAttestation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Attest against the provided draft policy. Note that the resulting token cannot
 be validated."""
    nonce: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Nonce for incoming request - emitted in the generated attestation token."""

    @overload
    def __init__(
        self,
        *,
        report: Optional[bytes] = None,
        runtime_data: Optional["_models.RuntimeData"] = None,
        init_time_data: Optional["_models.InitTimeData"] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AttestSgxEnclaveRequest(_Model):
    """Attestation request for Intel SGX enclaves.

    :ivar quote: Quote of the enclave to be attested.
    :vartype quote: bytes
    :ivar runtime_data: Runtime data provided by the enclave at the time of quote generation.
    :vartype runtime_data: ~azure.security.attestation.models.RuntimeData
    :ivar init_time_data: Initialization data provided when the enclave is created.
    :vartype init_time_data: ~azure.security.attestation.models.InitTimeData
    :ivar draft_policy_for_attestation: Attest against the provided draft policy.
    :vartype draft_policy_for_attestation: str
    :ivar nonce: Nonce for incoming request - emitted in the generated attestation token.
    :vartype nonce: str
    """

    quote: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Quote of the enclave to be attested."""
    runtime_data: Optional["_models.RuntimeData"] = rest_field(
        name="runtimeData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Runtime data provided by the enclave at the time of quote generation. The MAA
 will verify that the first 32 bytes of the report_data field of the quote
 contains the SHA256 hash of the decoded \"data\" field of the runtime data."""
    init_time_data: Optional["_models.InitTimeData"] = rest_field(
        name="initTimeData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Initialization data provided when the enclave is created. MAA will verify that
 the init data was known to the enclave. Note that InitTimeData is invalid for
 CoffeeLake processors."""
    draft_policy_for_attestation: Optional[str] = rest_field(
        name="draftPolicyForAttestation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Attest against the provided draft policy. Note that the resulting token cannot
 be validated."""
    nonce: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Nonce for incoming request - emitted in the generated attestation token."""

    @overload
    def __init__(
        self,
        *,
        quote: Optional[bytes] = None,
        runtime_data: Optional["_models.RuntimeData"] = None,
        init_time_data: Optional["_models.InitTimeData"] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InitTimeData(_Model):
    """Initialization time data for Trusted Execution Environment (TEE).

    :ivar data: Initialization time data passed into the TEE when it is created.
    :vartype data: bytes
    :ivar data_type: The type of data contained within the data field.
    :vartype data_type: str or ~azure.security.attestation.models.DataType
    """

    data: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Initialization time data are passed into the Trusted Execution Environment
 (TEE) when it is created. For an Icelake SGX quote, the SHA256 hash of the
 InitTimeData must match the lower 32 bytes of the quote's \"config id\"
 attribute. For a SEV-SNP quote, the SHA256 hash of the InitTimeData must match
 the quote's \"host data\" attribute."""
    data_type: Optional[Union[str, "_models.DataType"]] = rest_field(
        name="dataType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of data contained within the \"data\" field. Known values are: \"Binary\" and
     \"JSON\"."""

    @overload
    def __init__(
        self,
        *,
        data: Optional[bytes] = None,
        data_type: Optional[Union[str, "_models.DataType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JsonWebKey(_Model):
    """JsonWebKey.

    :ivar alg: Algorithm parameter for the key.
    :vartype alg: str
    :ivar crv: Curve parameter identifies the curve type.
    :vartype crv: str
    :ivar d: RSA private exponent or ECC private key.
    :vartype d: str
    :ivar dp: RSA Private Key Parameter.
    :vartype dp: str
    :ivar dq: RSA Private Key Parameter.
    :vartype dq: str
    :ivar e: RSA public exponent, in Base64.
    :vartype e: str
    :ivar k: Symmetric key.
    :vartype k: str
    :ivar kid: Key ID parameter used to match a specific key.
    :vartype kid: str
    :ivar kty: Key type parameter identifies the cryptographic algorithm family.
    :vartype kty: str
    :ivar n: RSA modulus, in Base64.
    :vartype n: str
    :ivar p: RSA secret prime.
    :vartype p: str
    :ivar q: RSA secret prime, with p < q.
    :vartype q: str
    :ivar qi: RSA Private Key Parameter.
    :vartype qi: str
    :ivar use: Public key use parameter.
    :vartype use: str
    :ivar x: X coordinate for the Elliptic Curve point.
    :vartype x: str
    :ivar x5_c: X.509 certificate chain parameter.
    :vartype x5_c: list[str]
    :ivar y: Y coordinate for the Elliptic Curve point.
    :vartype y: str
    """

    alg: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The \"alg\" (algorithm) parameter identifies the algorithm intended for
 use with the key.  The values used should either be registered in the
 IANA \"JSON Web Signature and Encryption Algorithms\" registry
 established by [JWA] or be a value that contains a Collision-
 Resistant Name."""
    crv: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The \"crv\" (curve) parameter identifies the curve type."""
    d: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA private exponent or ECC private key."""
    dp: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA Private Key Parameter."""
    dq: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA Private Key Parameter."""
    e: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA public exponent, in Base64."""
    k: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Symmetric key."""
    kid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The \"kid\" (key ID) parameter is used to match a specific key.  This
 is used, for instance, to choose among a set of keys within a JWK Set
 during key rollover.  The structure of the \"kid\" value is
 unspecified.  When \"kid\" values are used within a JWK Set, different
 keys within the JWK Set SHOULD use distinct \"kid\" values.  (One
 example in which different keys might use the same \"kid\" value is if
 they have different \"kty\" (key type) values but are considered to be
 equivalent alternatives by the application using them.)  The \"kid\"
 value is a case-sensitive string."""
    kty: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The \"kty\" (key type) parameter identifies the cryptographic algorithm
 family used with the key, such as \"RSA\" or \"EC\". \"kty\" values should
 either be registered in the IANA \"JSON Web Key Types\" registry
 established by [JWA] or be a value that contains a Collision-
 Resistant Name.  The \"kty\" value is a case-sensitive string. Required."""
    n: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA modulus, in Base64."""
    p: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA secret prime."""
    q: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA secret prime, with p < q."""
    qi: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA Private Key Parameter."""
    use: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Use (\"public key use\") identifies the intended use of
 the public key. The \"use\" parameter is employed to indicate whether
 a public key is used for encrypting data or verifying the signature
 on data. Values are commonly \"sig\" (signature) or \"enc\" (encryption)."""
    x: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """X coordinate for the Elliptic Curve point."""
    x5_c: Optional[list[str]] = rest_field(name="x5c", visibility=["read", "create", "update", "delete", "query"])
    """The \"x5c\" (X.509 certificate chain) parameter contains a chain of one
 or more PKIX certificates [RFC5280].  The certificate chain is
 represented as a JSON array of certificate value strings.  Each
 string in the array is a base64-encoded (Section 4 of [RFC4648] --
 not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value.
 The PKIX certificate containing the key value MUST be the first
 certificate."""
    y: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Y coordinate for the Elliptic Curve point."""

    @overload
    def __init__(
        self,
        *,
        kty: str,
        alg: Optional[str] = None,
        crv: Optional[str] = None,
        d: Optional[str] = None,
        dp: Optional[str] = None,
        dq: Optional[str] = None,
        e: Optional[str] = None,
        k: Optional[str] = None,
        kid: Optional[str] = None,
        n: Optional[str] = None,
        p: Optional[str] = None,
        q: Optional[str] = None,
        qi: Optional[str] = None,
        use: Optional[str] = None,
        x: Optional[str] = None,
        x5_c: Optional[list[str]] = None,
        y: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JsonWebKeySet(_Model):
    """JsonWebKeySet.

    :ivar keys_property: Array of JWK values.
    :vartype keys_property: list[~azure.security.attestation.models.JsonWebKey]
    """

    keys_property: Optional[list["_models.JsonWebKey"]] = rest_field(
        name="keys", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value of the \"keys\" parameter is an array of JWK values.  By
 default, the order of the JWK values within the array does not imply
 an order of preference among them, although applications of JWK Sets
 can choose to assign a meaning to the order for their purposes, if
 desired."""

    @overload
    def __init__(
        self,
        *,
        keys_property: Optional[list["_models.JsonWebKey"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OpenIDConfigurationResponse(_Model):
    """The response to the OpenID metadata description document API.

    :ivar response_types_supported: Types supported in the OpenID metadata API.
    :vartype response_types_supported: list[str]
    :ivar id_token_signing_alg_values_supported: List of the supported signing algorithms.
    :vartype id_token_signing_alg_values_supported: list[str]
    :ivar revocation_endpoint: Revocation endpoint.
    :vartype revocation_endpoint: str
    :ivar issuer: Issuer tenant base endpoint.
    :vartype issuer: str
    :ivar jwks_uri: The URI to retrieve the signing keys.
    :vartype jwks_uri: str
    :ivar claims_supported: Set of claims supported by the OpenID metadata endpoint.
    :vartype claims_supported: list[str]
    """

    response_types_supported: Optional[list[str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Types supported in the OpenID metadata API."""
    id_token_signing_alg_values_supported: Optional[list[str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of the supported signing algorithms."""
    revocation_endpoint: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Revocation endpoint."""
    issuer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Issuer tenant base endpoint."""
    jwks_uri: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URI to retrieve the signing keys."""
    claims_supported: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Set of claims supported by the OpenID metadata endpoint."""

    @overload
    def __init__(
        self,
        *,
        response_types_supported: Optional[list[str]] = None,
        id_token_signing_alg_values_supported: Optional[list[str]] = None,
        revocation_endpoint: Optional[str] = None,
        issuer: Optional[str] = None,
        jwks_uri: Optional[str] = None,
        claims_supported: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyCertificatesModificationResult(_Model):
    """The result of a policy certificate modification.

    :ivar certificate_thumbprint: Hex encoded SHA1 Hash of the certificate.
    :vartype certificate_thumbprint: str
    :ivar certificate_resolution: The result of the operation.
    :vartype certificate_resolution: str or ~azure.security.attestation.models.CertificateModification
    """

    certificate_thumbprint: Optional[str] = rest_field(
        name="x-ms-certificate-thumbprint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Hex encoded SHA1 Hash of the binary representation certificate which was added
 or removed."""
    certificate_resolution: Optional[Union[str, "_models.CertificateModification"]] = rest_field(
        name="x-ms-policycertificates-result", visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of the operation. Known values are: \"IsPresent\" and \"IsAbsent\"."""

    @overload
    def __init__(
        self,
        *,
        certificate_thumbprint: Optional[str] = None,
        certificate_resolution: Optional[Union[str, "_models.CertificateModification"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyCertificatesModifyResponse(_Model):
    """The response to an attestation policy management API.

    :ivar token: RFC7519 JSON Web Token with PolicyCertificatesModificationResult body.
    :vartype token: str
    """

    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An RFC7519 JSON Web Token structure whose body is a
 PolicyCertificatesModificationResult object."""

    @overload
    def __init__(
        self,
        *,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyCertificatesResponse(_Model):
    """The response to an attestation policy management API.

    :ivar token: RFC7519 JSON Web Token containing PolicyCertificatesResults object.
    :vartype token: str
    """

    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An RFC7519 JSON Web Token structure containing a PolicyCertificatesResults
 object which contains the certificates used to validate policy changes."""

    @overload
    def __init__(
        self,
        *,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyCertificatesResult(_Model):
    """The result of a call to retrieve policy certificates.

    :ivar policy_certificates: SHA256 Hash of the binary representation certificate which was added
     or removed.
    :vartype policy_certificates: ~azure.security.attestation.models.JsonWebKeySet
    """

    policy_certificates: Optional["_models.JsonWebKeySet"] = rest_field(
        name="x-ms-policy-certificates", visibility=["read", "create", "update", "delete", "query"]
    )
    """SHA256 Hash of the binary representation certificate which was added or removed."""

    @overload
    def __init__(
        self,
        *,
        policy_certificates: Optional["_models.JsonWebKeySet"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyResponse(_Model):
    """The response to an attestation policy operation.

    :ivar token: An RFC7519 JSON Web Token structure whose body is an PolicyResult object.
    :vartype token: str
    """

    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An RFC7519 JSON Web Token structure whose body is an PolicyResult object."""

    @overload
    def __init__(
        self,
        *,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyResult(_Model):
    """The result of a policy certificate modification.

    :ivar policy_resolution: The result of the operation.
    :vartype policy_resolution: str or ~azure.security.attestation.models.PolicyModification
    :ivar policy_token_hash: The SHA256 hash of the policy object modified.
    :vartype policy_token_hash: bytes
    :ivar policy_signer: The certificate used to sign the policy object.
    :vartype policy_signer: ~azure.security.attestation.models.JsonWebKey
    :ivar policy: JSON Web Token containing a StoredAttestationPolicy object.
    :vartype policy: str
    """

    policy_resolution: Optional[Union[str, "_models.PolicyModification"]] = rest_field(
        name="x-ms-policy-result", visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of the operation. Known values are: \"Updated\" and \"Removed\"."""
    policy_token_hash: Optional[bytes] = rest_field(
        name="x-ms-policy-token-hash", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """The SHA256 hash of the policy object modified."""
    policy_signer: Optional["_models.JsonWebKey"] = rest_field(
        name="x-ms-policy-signer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The certificate used to sign the policy object, if specified."""
    policy: Optional[str] = rest_field(name="x-ms-policy", visibility=["read", "create", "update", "delete", "query"])
    """A JSON Web Token containing a StoredAttestationPolicy object with the
 attestation policy."""

    @overload
    def __init__(
        self,
        *,
        policy_resolution: Optional[Union[str, "_models.PolicyModification"]] = None,
        policy_token_hash: Optional[bytes] = None,
        policy_signer: Optional["_models.JsonWebKey"] = None,
        policy: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RuntimeData(_Model):
    """Runtime data provided during attestation.

    :ivar data: Runtime data passed into the TEE during attestation.
    :vartype data: bytes
    :ivar data_type: The type of data contained within the data field.
    :vartype data_type: str or ~azure.security.attestation.models.DataType
    """

    data: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Runtime data are generated by the Trusted Execution Environment (TEE). For an
 SGX quote (Coffeelake or Icelake), the SHA256 hash of the RuntimeData must
 match the lower 32 bytes of the quote's \"report data\" attribute. For a SEV-SNP
 quote, the SHA256 hash of the RuntimeData must match the quote's \"report data\"
 attribute."""
    data_type: Optional[Union[str, "_models.DataType"]] = rest_field(
        name="dataType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of data contained within the \"data\" field. Known values are: \"Binary\" and
     \"JSON\"."""

    @overload
    def __init__(
        self,
        *,
        data: Optional[bytes] = None,
        data_type: Optional[Union[str, "_models.DataType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SealedAttestationResponse(_Model):
    """The sealed result of an attestation operation.

    :ivar token: Sealed RFC 7519 JSON Web Token with AttestationResult body.
    :vartype token: str
    """

    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A sealed RFC 7519 JSON Web Token, the body of which is an AttestationResult
 object."""

    @overload
    def __init__(
        self,
        *,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoredAttestationPolicy(_Model):
    """StoredAttestationPolicy.

    :ivar attestation_policy: Policy text to set as a sequence of UTF-8 encoded octets.
    :vartype attestation_policy: bytes
    """

    attestation_policy: Optional[bytes] = rest_field(
        name="AttestationPolicy", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """Policy text to set as a sequence of UTF-8 encoded octets."""

    @overload
    def __init__(
        self,
        *,
        attestation_policy: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TcbBaseline(_Model):
    """TEE specific Tcb baseline used in attestation.

    :ivar tcb_identifier: The Tcb baseline Identifier used in attestation policy.
    :vartype tcb_identifier: str
    :ivar tcb_evaluation_data_number: Monotonically increasing sequence number.
    :vartype tcb_evaluation_data_number: int
    :ivar tcb_release_date: Date and time when the Tcb is released.
    :vartype tcb_release_date: ~datetime.datetime
    :ivar minimum_psw_linux_version: Minimum Linux PSW version required.
    :vartype minimum_psw_linux_version: str
    :ivar minimum_psw_windows_version: Minimum Windows PSW version required.
    :vartype minimum_psw_windows_version: str
    :ivar is_selected_tcb: Whether this Tcb baseline is used in attestation.
    :vartype is_selected_tcb: bool
    """

    tcb_identifier: Optional[str] = rest_field(
        name="tcbIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Tcb baseline Identifier used in attestation policy."""
    tcb_evaluation_data_number: Optional[int] = rest_field(
        name="tcbEvaluationDataNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """A monotonically increasing sequence number changed when Intel updates the
 content of the TCB evaluation data set. SGX TEE specific property."""
    tcb_release_date: Optional[datetime.datetime] = rest_field(
        name="tcbReleaseDate", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time when the Tcb is released. SGX TEE specific property."""
    minimum_psw_linux_version: Optional[str] = rest_field(
        name="minimumPswLinuxVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum Linux PSW version required to support the corresponding Tcb baseline.
 SGX TEE specific property."""
    minimum_psw_windows_version: Optional[str] = rest_field(
        name="minimumPswWindowsVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum Windows PSW version required to support the corresponding Tcb baseline.
 SGX TEE specific property."""
    is_selected_tcb: Optional[bool] = rest_field(
        name="isSelectedTcb", visibility=["read", "create", "update", "delete", "query"]
    )
    """The corresponding Tcb baseline is set in attestation policy and is used in
 attestation request if set to true."""

    @overload
    def __init__(
        self,
        *,
        tcb_identifier: Optional[str] = None,
        tcb_evaluation_data_number: Optional[int] = None,
        tcb_release_date: Optional[datetime.datetime] = None,
        minimum_psw_linux_version: Optional[str] = None,
        minimum_psw_windows_version: Optional[str] = None,
        is_selected_tcb: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TcbBaselineResult(_Model):
    """Azure supported baseline details for a TEE type.

    :ivar tcb_baselines: List of Azure supported baseline details for the TEE type.
    :vartype tcb_baselines: list[~azure.security.attestation.models.TcbBaseline]
    """

    tcb_baselines: Optional[list["_models.TcbBaseline"]] = rest_field(
        name="tcbBaselines", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of all Azure supported baseline details for the a TEE type along with an
 indication of which one is in enforced for the attestation provider."""

    @overload
    def __init__(
        self,
        *,
        tcb_baselines: Optional[list["_models.TcbBaseline"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TpmAttestationResponse(_Model):
    """Attestation response for Trusted Platform Module (TPM) attestation.

    :ivar data: Protocol data containing attestation service response.
    :vartype data: bytes
    """

    data: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Protocol data containing attestation service response."""

    @overload
    def __init__(
        self,
        *,
        data: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
