Keyboard walks, also sometimes known as waterfalls or "spatial pattern" passwords, are passwords generated by typing adjacent keys on the keyboard, with `[SHIFT]` held occasionally in order to meet common complexity requirements (i.e. capital letters + symbols). These passwords may resemble randomly generated strings but are not nearly as strong, as they often follow predictable patterns and are easy to guess despite meeting length and complexity requirements. Due to both the structure of the QWERTY keyboard and [human preferences for memory chunking](https://www.sciencedirect.com/science/article/abs/pii/0010028572900126), most keyboard walks tend to consist of multiples of four characters (4, 8, 12, 16, etc.)

Some examples of commonly-used keyboard walk patterns are shown below: \
1. `1qaz@WSX3edc$RFV (one-down, shift two-down, three-down, shift four-down)`
2. `ZAQ!2wsxXSW@1qaz (shift one-up, two-down, shift two-up, one-down)`
3. `1234qwer$#@!REWQ (one-right, q-right, shift one-left, shift q-left)`
4. `1q2w#E$R (half one-down, half two-down, shift half three-down, shift half four-down)`

These types of patterns should be thoroughly searched for during offline password cracking as keyboard walks are used often and do not contribute to strong security practices.

---

[walk-the-line.txt](https://github.com/danielmiessler/SecLists/blob/master/Passwords/Keyboard-Walks/walk-the-line.txt) was generated by iteratively concatenating basic 4-character patterns together into passwords of 8, 12, and 16 characters. The example passwords shown above can all be found within this file.
