/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;
import sun.swing.SwingUtilities2;

public class DarculaModLabelUI
extends MetalLabelUI {
    private static final UIDefaults LAF;
    private static final String LABEL_BG_PREFIX = "Label.darculaMod.label-bg";
    private static final int LABEL_BG_COUNT;
    private static final List<Color> LABEL_BGS;
    private static final String LABEL_FG_PREFIX = "Label.darculaMod.label-fg";
    private static final int LABEL_FG_COUNT;
    private static final List<Color> LABEL_FGS;
    public static final Color LABEL_DESIRED_FG;

    public static ComponentUI createUI(JComponent b) {
        return new DarculaModLabelUI();
    }

    @Override
    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsUtil.setupTextAntialiasing(g, c);
        boolean changed = this.changeForegroundOfLabelWithHtmlText(g, c);
        Color fg = c.getForeground();
        if (changed) {
            c.setForeground(LABEL_DESIRED_FG);
        }
        super.paint(g, c);
        if (changed) {
            c.setForeground(fg);
        }
    }

    private boolean changeForegroundOfLabelWithHtmlText(Graphics g, JComponent c) {
        if (c.isEnabled() && c.getClientProperty("html") != null && DarculaModLabelUI.isInBalloonManager(c)) {
            if (DarculaModLabelUI.makeDesiredForeground(c, false)) {
                return true;
            }
            if (DarculaModLabelUI.makeDesiredForeground(c, true)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInBalloonManager(JComponent c) {
        String text = ((JLabel)c).getText();
        if (text != null && text.contains("Unexpected Exception")) {
            return true;
        }
        Container parent = c.getParent();
        if (parent != null) {
            return (parent = parent.getParent()) != null && parent.getClass().getName().startsWith("org.netbeans.core.ui.notifications.BalloonManager");
        }
        return false;
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        super.paintDisabledText(l, g, s, textX, textY);
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        g.setColor(DarculaModLabelUI.makeDesiredForeground(l, false) ? LABEL_DESIRED_FG : l.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        if (SystemInfo.isLinux && preferredSize.width > 0) {
            preferredSize.width += 8;
        }
        return preferredSize;
    }

    public static boolean makeDesiredForeground(JComponent l, boolean ignoreLabelOpaque) {
        if (l != null && DarculaModLabelUI.foregroundMatches(l.getForeground())) {
            if (ignoreLabelOpaque || l.isOpaque()) {
                Color bg = l.getBackground();
                return DarculaModLabelUI.backgroundMathes(bg);
            }
            Container parent = l.getParent();
            if (DarculaModLabelUI.isOpaqueBackground(parent)) {
                Color bg = parent.getBackground();
                return DarculaModLabelUI.backgroundMathes(bg);
            }
            for (int level = 0; level < 1 && parent != null && parent instanceof Container && !parent.isOpaque(); parent = parent.getParent(), ++level) {
            }
            if (DarculaModLabelUI.isOpaqueBackground(parent)) {
                Color bg = parent.getBackground();
                return DarculaModLabelUI.backgroundMathes(bg);
            }
        }
        return false;
    }

    private static boolean foregroundMatches(Color fg) {
        return LABEL_FGS.stream().anyMatch(colour -> colour.equals(fg));
    }

    private static boolean backgroundMathes(Color bg) {
        return LABEL_BGS.stream().anyMatch(colour -> colour.equals(bg));
    }

    private static boolean isOpaqueBackground(Container container) {
        return container != null && container instanceof Container && container.isOpaque();
    }

    static {
        int i;
        LAF = UIManager.getLookAndFeelDefaults();
        LABEL_BG_COUNT = LAF.getInt("Label.darculaMod.label-bg-count");
        LABEL_BGS = new ArrayList<Color>();
        LABEL_FG_COUNT = LAF.getInt("Label.darculaMod.label-fg-count");
        LABEL_FGS = new ArrayList<Color>();
        LABEL_DESIRED_FG = LAF.getColor("Label.darculaMod.label-desired-fg");
        for (i = 1; i < LABEL_BG_COUNT + 1; ++i) {
            Color bg = LAF.getColor(LABEL_BG_PREFIX + i);
            if (bg == null) continue;
            LABEL_BGS.add(bg);
        }
        for (i = 1; i < LABEL_FG_COUNT + 1; ++i) {
            Color fg = LAF.getColor(LABEL_FG_PREFIX + i);
            if (fg == null) continue;
            LABEL_FGS.add(fg);
        }
    }
}

