/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.find.files.actions.MergeWithActiveGraphAction;
import com.paterva.maltego.find.files.actions.OpenGraphAction;
import com.paterva.maltego.find.files.nodes.FoundEntityNode;
import com.paterva.maltego.find.files.nodes.FoundLinkNode;
import com.paterva.maltego.find.files.nodes.GraphProperties;
import com.paterva.maltego.find.files.nodes.PropertyUtils;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class FoundGraphNode
extends AbstractNode {
    private static SoftReference<Image> _icon16;
    private static SoftReference<Image> _icon32;

    public FoundGraphNode(FindInFilesResult result) {
        this(result, new InstanceContent());
    }

    public FoundGraphNode(FindInFilesResult result, InstanceContent content) {
        super(Children.create((ChildFactory)new FoundPartsChildFactory(result), (boolean)true), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)result);
        content.add((Object)this);
        this.setDisplayName(result.getGraphName());
    }

    public Image getIcon(int type) {
        return FoundGraphNode.getCachedImage(type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private static Image getCachedImage(int type) {
        Image image;
        if (type == 1 || type == 3) {
            Image image2 = image = _icon16 != null ? _icon16.get() : null;
            if (image == null) {
                image = ImageUtilities.loadImage((String)"com/paterva/maltego/find/resources/Graph.png", (boolean)true);
                _icon16 = new SoftReference<Image>(image);
            }
        } else {
            Image image3 = image = _icon32 != null ? _icon32.get() : null;
            if (image == null) {
                image = ImageUtilities.loadImage((String)"com/paterva/maltego/find/resources/Graph32.png", (boolean)true);
                _icon32 = new SoftReference<Image>(image);
            }
        }
        return image;
    }

    protected Sheet createSheet() {
        Sheet sheet = PropertySheetFactory.createDefaultSheet();
        GraphProperties.add(sheet, (Node)this);
        PropertyUtils.addGraphFindProperties(sheet, (Node)this);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        Action[] actions = new Action[]{SystemAction.get(OpenGraphAction.class), SystemAction.get(MergeWithActiveGraphAction.class)};
        return actions;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenGraphAction.class);
    }

    private static class FoundPartsChildFactory
    extends ChildFactory<FindInFilesResult.Part> {
        private final FindInFilesResult _result;

        public FoundPartsChildFactory(FindInFilesResult result) {
            this._result = result;
        }

        protected boolean createKeys(List<FindInFilesResult.Part> toPopulate) {
            toPopulate.addAll(this._result.getMatchedParts());
            return true;
        }

        protected Node createNodeForKey(FindInFilesResult.Part key) {
            MaltegoPart part = key.getPart();
            if (part instanceof MaltegoEntity) {
                return new FoundEntityNode((MaltegoEntity)part, key.getMatchSnippet());
            }
            if (part instanceof MaltegoLink) {
                return new FoundLinkNode((MaltegoLink)part, key.getMatchSnippet());
            }
            return null;
        }
    }
}

