/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.discovery;

import com.paterva.maltego.discovery.DiscoveryMergingRules;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscoveryEntityMerger {
    private static final Logger LOG = Logger.getLogger(DiscoveryEntityMerger.class.getName());

    public static boolean merge(EntityRegistry registry, MaltegoEntitySpec newSpec, DiscoveryMergingRules.EntityRule entityRule) {
        if ((newSpec = DiscoveryEntityMerger.getNewEntity(registry, entityRule, newSpec)) != null) {
            registry.put((TypeSpec)newSpec, newSpec.getDefaultCategory());
        }
        return newSpec != null;
    }

    public static MaltegoEntitySpec getNewEntity(EntityRegistry registry, DiscoveryMergingRules.EntityRule entityRule, MaltegoEntitySpec newSpec) {
        MaltegoEntitySpec newSpecMerged = null;
        MaltegoEntitySpec oldSpec = (MaltegoEntitySpec)registry.get(newSpec.getTypeName());
        LOG.log(Level.FINE, "Old spec: {0}", oldSpec);
        LOG.log(Level.FINE, "New spec: {0}", newSpec);
        if (oldSpec == null) {
            newSpecMerged = newSpec;
            LOG.fine("Adding previously unknown entity");
        } else {
            switch (entityRule) {
                case REPLACE: {
                    if (newSpec.isCopy((Object)oldSpec)) break;
                    newSpecMerged = newSpec;
                    LOG.fine("Replacing entity");
                    break;
                }
                case IGNORE: {
                    LOG.fine("Ignoring new spec");
                    break;
                }
                case MERGE: {
                    MaltegoEntitySpec mergedSpec = new MaltegoEntitySpec(oldSpec);
                    mergedSpec.mergeWith(newSpec);
                    if (mergedSpec.isCopy((Object)oldSpec)) break;
                    newSpecMerged = mergedSpec;
                    LOG.fine("Merging entity specs");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown entity rule " + (Object)((Object)entityRule));
                }
            }
        }
        return newSpecMerged;
    }
}

