/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.notifications.data;

import com.paterva.maltego.notifications.data.ServerNotificationButton;
import com.paterva.maltego.notifications.data.ServerNotificationContent;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="Notice", strict=false)
public class ServerNotification {
    private static final ServerNotificationButton CLOSE_BUTTON = new ServerNotificationButton("close", "Close");
    @Attribute(name="title")
    private String title;
    @Attribute(name="width", required=false)
    private Integer width;
    @Attribute(name="height", required=false)
    private Integer height;
    @Element(name="Content")
    private ServerNotificationContent content;
    @ElementList(name="Buttons", required=false)
    private List<ServerNotificationButton> buttons;

    public ServerNotification() {
    }

    public ServerNotification(String title, Integer width, Integer height, ServerNotificationContent content, List<ServerNotificationButton> buttons) {
        this.title = title;
        this.width = width;
        this.height = height;
        this.content = content;
        this.buttons = buttons;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<Integer> getWidth() {
        return Optional.ofNullable(this.width);
    }

    public Optional<Integer> getHeight() {
        return Optional.ofNullable(this.height);
    }

    public ServerNotificationContent getContent() {
        return this.content;
    }

    public List<ServerNotificationButton> getButtons() {
        return this.buttons != null && !this.buttons.isEmpty() ? this.buttons : Collections.singletonList(CLOSE_BUTTON);
    }
}

