/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.java;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class JavaElementHandle
implements ElementHandle {
    private final URL anchorURL;
    private final String name;
    private final String ownerFQN;
    private final org.netbeans.modules.csl.api.ElementKind kind;
    private final List<String> signatureInfo;
    private final Set<Modifier> modifiers;
    private final org.netbeans.api.java.source.ElementHandle elementHandle;

    public JavaElementHandle(String name, String ownerFQN, org.netbeans.api.java.source.ElementHandle h, List<String> signatureInfo, Set<Modifier> modifiers) {
        assert (name != null) : "simple name is needed";
        this.anchorURL = null;
        this.name = name;
        this.ownerFQN = ownerFQN;
        this.elementHandle = h;
        this.kind = JavaElementHandle.fromJavaKind(h.getKind());
        this.signatureInfo = signatureInfo == null ? Collections.emptyList() : signatureInfo;
        this.modifiers = modifiers == null ? Collections.emptySet() : modifiers;
    }

    private static org.netbeans.modules.csl.api.ElementKind fromJavaKind(ElementKind k) {
        switch (k) {
            case CLASS: {
                return org.netbeans.modules.csl.api.ElementKind.CLASS;
            }
            case INTERFACE: {
                return org.netbeans.modules.csl.api.ElementKind.INTERFACE;
            }
            case METHOD: {
                return org.netbeans.modules.csl.api.ElementKind.METHOD;
            }
            case FIELD: {
                return org.netbeans.modules.csl.api.ElementKind.FIELD;
            }
            case CONSTRUCTOR: {
                return org.netbeans.modules.csl.api.ElementKind.CONSTRUCTOR;
            }
            case ENUM: {
                return org.netbeans.modules.csl.api.ElementKind.CONSTANT;
            }
            case ANNOTATION_TYPE: {
                return org.netbeans.modules.csl.api.ElementKind.INTERFACE;
            }
        }
        throw new IllegalArgumentException("Unsupported: " + (Object)((Object)k));
    }

    public JavaElementHandle(URL anchorURL, String name, String ownerFQN, org.netbeans.modules.csl.api.ElementKind kind, List<String> signatureInfo, Set<Modifier> modifiers) {
        assert (anchorURL != null) : "Need an anchor to resolve the handle in the future";
        assert (name != null) : "simple name is needed";
        assert (kind != null);
        this.anchorURL = anchorURL;
        this.name = name;
        this.ownerFQN = ownerFQN;
        this.kind = kind;
        this.signatureInfo = signatureInfo == null ? Collections.emptyList() : signatureInfo;
        this.modifiers = modifiers == null ? Collections.emptySet() : modifiers;
        this.elementHandle = null;
    }

    public FileObject getFileObject() {
        return URLMapper.findFileObject((URL)this.anchorURL);
    }

    public String getMimeType() {
        return "text/x-java";
    }

    public String getName() {
        return this.name;
    }

    public String getIn() {
        return this.ownerFQN;
    }

    public org.netbeans.modules.csl.api.ElementKind getKind() {
        return this.kind;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public boolean signatureEquals(ElementHandle handle) {
        if (handle instanceof JavaElementHandle) {
            JavaElementHandle jeh = (JavaElementHandle)handle;
            if (jeh.elementHandle != null && this.elementHandle != null) {
                return this.elementHandle.signatureEquals(jeh.elementHandle);
            }
            return Objects.equals(jeh.signatureInfo, this.signatureInfo);
        }
        return false;
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return OffsetRange.NONE;
    }

    @CheckForNull
    public <T extends Element> T resolve(@NonNull CompilationInfo info) {
        return (T)this.toElement(info);
    }

    public <T> T extract(ParserResult groovyResult, final ElementFunction<T> resolver) throws IOException {
        FileObject origin = groovyResult.getSnapshot().getSource().getFileObject();
        if (origin == null) {
            if (this.anchorURL == null) {
                return null;
            }
            origin = URLMapper.findFileObject((URL)this.anchorURL);
        }
        final ClasspathInfo cpi = ClasspathInfo.create((FileObject)origin);
        class Processor
        implements Task<CompilationController>,
        ClasspathInfo.Provider {
            T result;
            Exception thrown;

            Processor() {
            }

            public void run(CompilationController parameter) throws Exception {
                try {
                    parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    this.result = resolver.apply((CompilationInfo)parameter, JavaElementHandle.this.toElement((CompilationInfo)parameter));
                }
                catch (Exception ex) {
                    this.thrown = ex;
                }
            }

            public ClasspathInfo getClasspathInfo() {
                return cpi;
            }
        }
        Processor inst = new Processor();
        JavaSource.create((ClasspathInfo)cpi, (FileObject[])new FileObject[0]).runUserActionTask((Task)inst, true);
        if (inst.thrown != null) {
            throw new IOException(inst.thrown);
        }
        return inst.result;
    }

    private Element toElement(CompilationInfo info) {
        if (this.elementHandle != null) {
            return this.elementHandle.resolve(info);
        }
        switch (this.kind) {
            case CLASS: {
                return info.getElements().getTypeElement(this.name);
            }
            case FIELD: 
            case CONSTANT: {
                TypeElement owner = info.getElements().getTypeElement(this.ownerFQN);
                if (owner == null) {
                    return null;
                }
                return ElementFilter.fieldsIn(owner.getEnclosedElements()).stream().filter(f -> f.getSimpleName().contentEquals(this.name)).findAny().orElse(null);
            }
            case METHOD: 
            case CONSTRUCTOR: {
                TypeElement owner = info.getElements().getTypeElement(this.ownerFQN);
                if (owner == null || !owner.getKind().isClass() && !owner.getKind().isInterface()) {
                    return null;
                }
                for (ExecutableElement e : this.kind == org.netbeans.modules.csl.api.ElementKind.METHOD ? ElementFilter.methodsIn(owner.getEnclosedElements()) : ElementFilter.constructorsIn(owner.getEnclosedElements())) {
                    if (this.kind == org.netbeans.modules.csl.api.ElementKind.METHOD && !e.getSimpleName().contentEquals(this.name)) continue;
                    ArrayList<String> sigTypes = new ArrayList<String>();
                    for (VariableElement variableElement : e.getParameters()) {
                        TypeMirror t = variableElement.asType();
                        sigTypes.add(info.getTypeUtilities().getTypeName(t, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString());
                    }
                    if (!sigTypes.equals(this.signatureInfo)) continue;
                    return e;
                }
                return null;
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface ElementFunction<T> {
        @CheckForNull
        public T apply(@NonNull CompilationInfo var1, @NullAllowed Element var2);
    }
}

