/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.rules.chain;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.rules.chain.ChainEntity;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.tools.CollectionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Chain {
    private boolean _endPt1Set = false;
    private boolean _endPt2Set = false;
    private EntityID _endPt1;
    private EntityID _endPt2;
    private final List<ChainEntity> _chainEntities = new ArrayList<ChainEntity>();
    private final List<EntityID> _chainEntitiesIDs = new ArrayList<EntityID>();
    private final Map<EntityID, EntityLinks> _entities;
    private final Map<LinkID, LinkEntityIDs> _links;

    public Chain(Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) {
        this._entities = entities;
        this._links = links;
    }

    public void addEndPoint(EntityID endPoint) {
        if (!this._endPt1Set) {
            this._endPt1 = endPoint;
            this._endPt1Set = true;
        } else if (!this._endPt2Set) {
            this._endPt2 = endPoint;
            this._endPt2Set = true;
        } else {
            throw new IllegalStateException("A chain cannot have more than 2 end points");
        }
    }

    public List<ChainEntity> getChainEntities() {
        return this._chainEntities;
    }

    public Map<LinkID, LinkEntityIDs> getLinks() {
        return this._links;
    }

    public Map<EntityID, EntityLinks> getEntities() {
        return this._entities;
    }

    public EntityID getEndPt1() {
        return this._endPt1;
    }

    public EntityID getEndPt2() {
        return this._endPt2;
    }

    boolean hasChainEntities() {
        return !this._chainEntities.isEmpty();
    }

    List<EntityID> getChainEntitiesWithOutEndPoints() {
        return this._chainEntitiesIDs;
    }

    void removeAllChainEntities() {
        this._chainEntitiesIDs.clear();
        this._chainEntities.clear();
    }

    void addChainEntity(EntityID ent, int incomingCount, int outgoingCount, String entityType) {
        this._chainEntitiesIDs.add(ent);
        this._chainEntities.add(new ChainEntity(ent, incomingCount, outgoingCount, entityType));
    }

    private boolean matchEndPoints(EntityID ent1, EntityID ent2) {
        if (ent1 == null) {
            return ent2 == null;
        }
        return ent1.equals((Object)ent2);
    }

    public boolean matches(Chain chain) {
        if (!this.matchEndPoints(this._endPt1, chain._endPt1) || !this.matchEndPoints(this._endPt2, chain._endPt2) || this.size() != chain.size()) {
            return false;
        }
        Iterator<ChainEntity> iterator1 = this._chainEntities.iterator();
        Iterator<ChainEntity> iterator2 = chain._chainEntities.iterator();
        while (iterator1.hasNext()) {
            ChainEntity ce1 = iterator1.next();
            ChainEntity ce2 = iterator2.next();
            if (ce1._entityType.equals(ce2._entityType) && ce1._incomingCount == ce2._incomingCount && ce1._outgoingCount == ce2._outgoingCount) continue;
            return false;
        }
        return true;
    }

    boolean isCollectable(ModelSnapshotData msd, int maxNeighbours) throws GraphStoreException {
        for (EntityID entityID : this._chainEntitiesIDs) {
            if (CollectionUtils.isCollectable(msd, entityID, maxNeighbours)) continue;
            return false;
        }
        return this._endPt1 == null && this._endPt2 == null || this._endPt1 != this._endPt2;
    }

    int size() {
        return this._chainEntities.size();
    }

    EntityID getEntity(int chainLevel) {
        return this._chainEntitiesIDs.get(chainLevel);
    }

    Set<LinkID> getIncomingLinkBetween(EntityID ent, EntityID entOther, Map<EntityID, EntityLinks> links) {
        return this.getOutgoingLinkBetween(entOther, ent, links);
    }

    Set<LinkID> getOutgoingLinkBetween(EntityID ent, EntityID entOther, Map<EntityID, EntityLinks> links) {
        EntityLinks entOtherLinks;
        HashSet<LinkID> outgoingLinks = new HashSet<LinkID>();
        EntityLinks entLinks = links.get(ent);
        if (entLinks != null && entLinks.hasModelOutgoingLinks() && (entOtherLinks = links.get(entOther)) != null && entOtherLinks.hasModelIncomingLinks()) {
            for (LinkID outgoingLinkID : entLinks.getModelOutgoingLinks()) {
                for (LinkID incomingLinkID : entOtherLinks.getModelIncomingLinks()) {
                    if (!outgoingLinkID.equals((Object)incomingLinkID)) continue;
                    outgoingLinks.add(incomingLinkID);
                }
            }
        }
        return outgoingLinks;
    }
}

