/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.transforms;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.finder.DiscoverySettings;
import com.paterva.maltego.transform.manager.imex.transforms.TransformConfig;
import com.paterva.maltego.transform.manager.imex.transforms.TransformDescriptorEntryFactory;
import com.paterva.maltego.transform.manager.imex.transforms.TransformDescriptorWrapper;
import com.paterva.maltego.transform.manager.imex.transforms.TransformExistInfo;
import com.paterva.maltego.transform.manager.imex.transforms.TransformServerEntryFactory;
import com.paterva.maltego.transform.manager.imex.transforms.TransformSettingsEntryFactory;
import com.paterva.maltego.transform.manager.imex.transforms.TransformSettingsWrapper;
import com.paterva.maltego.transform.repository.FSTransformRepositoryRegistry;
import com.paterva.maltego.transform.repository.FSTransformServerRegistry;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class TransformImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        List servers = reader.readAll((EntryFactory)new TransformServerEntryFactory(), "Graph1");
        List<TransformDescriptor> transforms = this.readTransforms(reader);
        return this.createConfig(transforms, servers);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        FSTransformServerRegistry oldServerRegistry = new FSTransformServerRegistry(configRoot);
        FSTransformRepositoryRegistry oldTransformRepositoryRegistry = new FSTransformRepositoryRegistry(configRoot);
        ArrayList<TransformServerInfo> servers = new ArrayList<TransformServerInfo>(oldServerRegistry.getAll());
        Set definitions = oldTransformRepositoryRegistry.find((TransformFilter)new FindAllFilter());
        ArrayList<TransformDescriptor> transforms = new ArrayList<TransformDescriptor>(definitions);
        return this.createConfig(transforms, servers);
    }

    private Config createConfig(Collection<TransformDescriptor> transforms, Collection<TransformServerInfo> servers) {
        ArrayList<TransformDescriptor> selected = new ArrayList<TransformDescriptor>();
        TransformExistInfo existInfo = new TransformExistInfo();
        for (TransformDescriptor transform : transforms) {
            if (existInfo.exist(transform)) continue;
            selected.add(transform);
        }
        if (servers.size() > 0 && transforms.size() > 0) {
            return new TransformConfig(servers.toArray(new TransformServerInfo[servers.size()]), transforms.toArray(new TransformDescriptor[transforms.size()]), selected.toArray(new TransformDescriptor[selected.size()]));
        }
        return null;
    }

    private List<TransformDescriptor> readTransforms(MaltegoArchiveReader reader) throws IOException {
        List transformDescriptors = reader.readAll((EntryFactory)new TransformDescriptorEntryFactory(), "Graph1");
        List transformSettings = reader.readAll((EntryFactory)new TransformSettingsEntryFactory(), "Graph1");
        this.mapSettingsToTransforms(transformDescriptors, transformSettings);
        return transformDescriptors;
    }

    private void mapSettingsToTransforms(List<TransformDescriptor> transforms, List<TransformSettings> transformSettings) {
        ArrayList<TransformDescriptor> transformsCopy = new ArrayList<TransformDescriptor>(transforms);
        transforms.clear();
        for (TransformDescriptor descriptor : transformsCopy) {
            for (TransformSettings settings : transformSettings) {
                TransformSettingsWrapper transformAwareSettings = (TransformSettingsWrapper)settings;
                if (!transformAwareSettings.getTransformName().equals(descriptor.getName())) continue;
                TransformDescriptorWrapper wrapper = (TransformDescriptorWrapper)descriptor;
                TransformDefinition definition = new TransformDefinition(descriptor, (TransformSettings)transformAwareSettings);
                definition.setRepositoryName(wrapper.getRepositoryName());
                descriptor = definition;
                break;
            }
            transforms.add(descriptor);
        }
    }

    public int applyConfig(Config config) {
        TransformConfig transformConfig = (TransformConfig)config;
        this.updateServers(transformConfig);
        this.updateTransforms(transformConfig);
        return ((TransformDescriptor[])transformConfig.getSelected()).length;
    }

    private void updateServers(TransformConfig transformConfig) {
        TransformServerRegistry registry = TransformServerRegistry.getDefault();
        for (TransformServerInfo server : transformConfig.getServers()) {
            if (!transformConfig.hasSelectedTransforms(server)) continue;
            TransformServerInfo oldServer = registry.get(server.getUrl());
            if (oldServer != null) {
                oldServer.getTransforms().addAll(server.getTransforms());
                continue;
            }
            server.setDirty();
            registry.put(server);
        }
    }

    private void updateTransforms(TransformConfig transformConfig) {
        TransformDescriptor[] selectedTransforms = (TransformDescriptor[])transformConfig.getSelected();
        this.updateTransforms(selectedTransforms);
    }

    public void updateTransforms(TransformDescriptor[] selectedTransforms) {
        try {
            for (TransformDescriptor transform : selectedTransforms) {
                TransformRepository repo;
                if (transform instanceof TransformDefinition) {
                    TransformDefinition definition = (TransformDefinition)transform;
                    repo = TransformRepositoryRegistry.getDefault().getOrCreateRepository(definition.getRepositoryName());
                    repo.put(transform);
                    this.updateProperties(repo, definition);
                    continue;
                }
                if (!(transform instanceof TransformDescriptorWrapper)) continue;
                TransformDescriptorWrapper wrapper = (TransformDescriptorWrapper)transform;
                repo = TransformRepositoryRegistry.getDefault().getOrCreateRepository(wrapper.getRepositoryName());
                repo.put(transform);
            }
            if (selectedTransforms.length > 0) {
                DiscoverySettings.setDiscoveryComplete((boolean)true);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateProperties(TransformRepository repo, TransformDefinition transform) {
        TransformDefinition repoTransform = repo.get(transform.getName());
        DisplayDescriptorCollection properties = transform.getProperties();
        for (DisplayDescriptor dd : properties) {
            Object value = transform.getValue((PropertyDescriptor)dd);
            repoTransform.setValue((PropertyDescriptor)dd, value);
        }
        repo.updateSettings(repoTransform);
    }

    private static class FindAllFilter
    implements TransformFilter {
        private FindAllFilter() {
        }

        public boolean matches(TransformDefinition def) {
            return true;
        }
    }
}

