/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics.queue;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.analytics.api.AnalyticsEvent;
import com.maltego.analytics.queue.EventJson;
import java.util.UUID;

public class QueuedEvent
implements Comparable<QueuedEvent> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final UUID id;
    private final long timestamp;
    private final String eventJson;

    public QueuedEvent(UUID id, long timestamp, String eventJson) {
        this.id = id;
        this.timestamp = timestamp;
        this.eventJson = eventJson;
    }

    public static QueuedEvent build(AnalyticsEvent ae) throws JsonProcessingException {
        EventJson eventJson = EventJson.build(ae);
        String eventJsonStr = MAPPER.writeValueAsString((Object)eventJson);
        return new QueuedEvent(ae.getTraceId(), ae.getTimestamp(), eventJsonStr);
    }

    public UUID getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEventJson() {
        return this.eventJson;
    }

    @Override
    public int compareTo(QueuedEvent e) {
        if (this.getTimestamp() <= e.getTimestamp()) {
            return -1;
        }
        return 1;
    }
}

