/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.discovery.DiscoveryMergingRules;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.discovery.TransformUpdater;
import com.paterva.maltego.transform.finder.wizard.FailurePanel;
import com.paterva.maltego.transform.finder.wizard.ProgressHandleAdapter;
import com.paterva.maltego.transform.finder.wizard.UpdateInstallPanel;
import com.paterva.maltego.transform.finder.wizard.UpdateInstallText;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformFindException;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputProvider;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;

class UpdateTransformsInstallController
extends PassFailProgressController<DiscoveryResult<TransformServerListing>, UpdateInstallPanel, FailurePanel>
implements WizardNavigationSupport {
    UpdateTransformsInstallController() {
    }

    protected DiscoveryResult<TransformServerListing> doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws DiscoveryException {
        DiscoveryResult listings = (DiscoveryResult)descriptor.getProperty("transformListings");
        DiscoveryResult references = (DiscoveryResult)descriptor.getProperty("transformReferences");
        ProgressHandleAdapter progress = new ProgressHandleAdapter(handle);
        HubSeedDescriptor hubSeed = (HubSeedDescriptor)descriptor.getProperty("hubItem");
        Boolean removeMissing = (Boolean)descriptor.getProperty("removeMissing");
        Object[] data = (TransformServerListing[])listings.getData();
        if (data == null || data.length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        handle.progress("Updating transforms and entities...");
        try {
            GlobalTransformInputProvider.getDefault().pauseUpdates();
            TransformUpdater txUpdater = TransformUpdater.getDefault();
            if (removeMissing.booleanValue()) {
                txUpdater.removeMissing((TransformServerListing[])data);
            }
            txUpdater.updateServers((TransformServerListing[])data);
            Exception[] errors = references.getErrors();
            if (errors == null || errors.length == 0) {
                txUpdater.removeMissingServers((TransformServerReference[])references.getData());
            }
            listings = new DiscoveryResult(data);
            txUpdater.update(hubSeed, (TransformServerListing[])data, DiscoveryMergingRules.getDefault());
            Boolean autoAcceptDisclaimers = (Boolean)descriptor.getProperty("autoAcceptDisclaimers");
            TransformRepository repository = TransformRepositoryRegistry.getDefault().getOrCreateRepository("Remote");
            if (autoAcceptDisclaimers.booleanValue()) {
                for (TransformServerListing listing : (TransformServerListing[])listings.getData()) {
                    Set transforms = listing.getTransforms();
                    for (TransformDescriptor transform : transforms) {
                        TransformDefinition def = repository.get(transform.getName());
                        def.setDisclaimerAccepted(true);
                        repository.updateSettings(def);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new DiscoveryException((Throwable)ex);
        }
        finally {
            GlobalTransformInputProvider.getDefault().resumeUpdates();
        }
        return listings;
    }

    protected UpdateInstallPanel createPassComponent() {
        return new UpdateInstallPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, UpdateInstallPanel component, DiscoveryResult<TransformServerListing> result) {
        UpdateInstallText urt = new UpdateInstallText();
        component.setText(urt.get((TransformServerListing[])result.getData()));
        component.setDuplicateTransforms(UpdateTransformsInstallController.getDuplicateTransforms((TransformServerListing[])result.getData()));
        descriptor.putProperty("success", (Object)Boolean.TRUE);
    }

    protected void fail(FailurePanel component, Exception e) {
        if (e == null) {
            component.setError(null);
        } else if (e instanceof DiscoveryException) {
            component.setError(e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null) {
                String msg = cause.getMessage();
                if (msg != null) {
                    component.setError(msg);
                }
                boolean knownCause = false;
                if (cause instanceof CertificateNeedValidationException) {
                    knownCause = this.setErrorMsg(msg, component);
                } else if (cause instanceof NoTrustedCertificateChainFoundException) {
                    knownCause = this.setErrorMsg(msg, component);
                } else if (cause instanceof RemoteTransformFindException) {
                    knownCause = this.setErrorMsg(msg, component);
                }
                if (knownCause) {
                    component.setTitle("Certificate chain is not trusted.");
                    String extraInfo = "Rerun this wizard from the \"Maltego Data Hub\" item under the \"Transforms\" ribbon tab after the certificate has been trusted.";
                    component.setMessage(extraInfo);
                }
            }
        } else {
            component.setError(e.getMessage());
        }
    }

    public boolean canBack() {
        return false;
    }

    protected String getFailureMessage() {
        int index3;
        int index2;
        int index1;
        String msg = super.getFailureMessage();
        if (msg != null && (index1 = msg.indexOf(" [Action:")) > -1 && (index2 = msg.indexOf("]", index1)) > -1 && (index3 = (msg = msg.substring(0, index2 + 1)).indexOf("n:")) > -1) {
            msg = msg.substring(0, index3 + 1);
        }
        return msg;
    }

    private boolean setErrorMsg(String msg, FailurePanel component) {
        int index2;
        int index1;
        boolean knownCause = false;
        if (msg != null && (index1 = msg.indexOf(" [Action:")) > -1 && (index2 = msg.indexOf("]", index1)) > -1) {
            msg = msg.substring(0, index2 + 1);
            knownCause = true;
            component.setError(msg);
        }
        return knownCause;
    }

    public static Map<HubSeedDescriptor, Set<TransformDescriptor>> getDuplicateTransforms(TransformServerListing[] data) {
        HashMap<HubSeedDescriptor, Set<TransformDescriptor>> duplicates = new HashMap<HubSeedDescriptor, Set<TransformDescriptor>>();
        for (TransformServerListing listing : data) {
            for (Map.Entry entry : listing.getDuplicateTransforms().entrySet()) {
                TransformDescriptor transform = (TransformDescriptor)entry.getKey();
                HubSeedDescriptor hubSeed = (HubSeedDescriptor)entry.getValue();
                HashSet<TransformDescriptor> transforms = (HashSet<TransformDescriptor>)duplicates.get(hubSeed);
                if (transforms == null) {
                    transforms = new HashSet<TransformDescriptor>();
                    duplicates.put(hubSeed, transforms);
                }
                transforms.add(transform);
            }
        }
        return duplicates;
    }
}

