/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import com.paterva.maltego.util.IconSize;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.modules.flamingo.Utils;
import java.awt.Image;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.openide.awt.Actions;
import org.openide.util.ImageUtilities;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public abstract class ActionItem {
    public static final String MENU_TEXT = "menuText";
    public static final String NO_ICON_IN_MENU = "noIconInMenu";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String ICON_BASE = "iconBase";
    public static final String TOOLTIP_BODY = "tooltipBody";
    public static final String TOOLTIP_TITLE = "tooltipTitle";
    public static final String TOOLTIP_ICON = "tooltipIcon";
    public static final String TOOLTIP_FOOTER = "tooltipFooter";
    public static final String TOOLTIP_FOOTER_ICON = "tooltipFooterIcon";
    public static final String DEFAULT_ACTION = "defaultAction";
    private Map<String, Object> _properties;

    public static ActionItem separator() {
        return new Separator();
    }

    public static ActionItem leaf(Action action) {
        return new Leaf(action);
    }

    public static ActionItem component(JComponent component) {
        return new Component(component);
    }

    public Action getAction() {
        return null;
    }

    public List<ActionItem> getChildren() {
        return Collections.emptyList();
    }

    public void addChild(ActionItem item) {
    }

    public boolean hasChildren() {
        return false;
    }

    public JComponent getComponent() {
        return null;
    }

    public ActionItem getActionDelegate() {
        return this;
    }

    public Object getValue(String key) {
        JComponent component;
        Object delegate;
        Map map;
        Action action;
        Object value = this.innerGetValue(key);
        if (value == null && (action = this.getAction()) != null && (value = action.getValue(key)) == null && (map = this.getInnerMap(action)) != null && (delegate = map.get("delegate")) != null && (map = this.getInnerMap(delegate)) != null) {
            value = map.get(key);
        }
        if (value == null && (component = this.getComponent()) != null) {
            value = component.getClientProperty(key);
        }
        return value;
    }

    private Map getInnerMap(Object action) {
        Map map = null;
        try {
            Object obj;
            Field field = action.getClass().getDeclaredField("map");
            field.setAccessible(true);
            if (field != null && (obj = field.get(action)) instanceof Map) {
                map = (Map)obj;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map;
    }

    public void putValue(String key, Object value) {
        if (this._properties == null) {
            this._properties = new TreeMap<String, Object>();
        }
        this._properties.put(key, value);
    }

    private Object innerGetValue(String key) {
        if (this._properties == null) {
            return null;
        }
        return this._properties.get(key);
    }

    public String getText() {
        String s = this.getValue(DISPLAY_NAME) != null ? this.getValue(DISPLAY_NAME).toString() : String.valueOf(this.getValue("Name"));
        return s != null ? Actions.cutAmpersand((String)s) : null;
    }

    public void setText(String name) {
        if (this.getValue(DISPLAY_NAME) == null && this.getValue(MENU_TEXT) == null) {
            this.putValue(DISPLAY_NAME, name);
        }
    }

    public String getMenuText() {
        String s = this.getValue(MENU_TEXT) != null ? Actions.cutAmpersand((String)this.getValue(MENU_TEXT).toString()) : this.getText();
        return s;
    }

    public String getDescription() {
        String s = null;
        if (this.getValue(DESCRIPTION) != null) {
            s = this.getValue(DESCRIPTION).toString();
        } else if (this.getValue("ShortDescription") != null) {
            s = String.valueOf(this.getValue("ShortDescription"));
        }
        return s;
    }

    public RichTooltip createTooltip() {
        String body = (String)this.getValue(TOOLTIP_BODY);
        if (body == null) {
            body = (String)this.getValue("LongDescription");
        }
        if (body == null) {
            body = this.getDescription();
        }
        if (body == null) {
            return null;
        }
        String title = (String)this.getValue(TOOLTIP_TITLE);
        if (title == null) {
            title = this.getText();
        }
        RichTooltip tooltip = new RichTooltip(title, body);
        String titleIcon = (String)this.getValue(TOOLTIP_ICON);
        if (titleIcon != null) {
            tooltip.setMainImage(ImageUtilities.loadImage((String)titleIcon));
        } else {
            tooltip.setMainImage(this.getLargeImage());
        }
        String footer = (String)this.getValue(TOOLTIP_FOOTER);
        if (footer != null) {
            tooltip.addFooterSection(footer);
            String footerIcon = (String)this.getValue(TOOLTIP_FOOTER_ICON);
            if (footerIcon != null) {
                tooltip.setFooterImage(ImageUtilities.loadImage((String)footerIcon));
            }
        }
        return tooltip;
    }

    private Image getLargeImage() {
        Object iconKey;
        String iconResource = (String)this.getValue(ICON_BASE);
        Image image = null;
        if (iconResource != null) {
            image = ImageUtilities.loadImage((String)Utils.insertBeforeSuffix(iconResource, IconSize.LARGE.getSize()));
            if (image == null) {
                image = ImageUtilities.loadImage((String)Utils.insertBeforeSuffix(iconResource, IconSize.MEDIUM.getSize()));
            }
            if (image == null) {
                image = ImageUtilities.loadImage((String)Utils.insertBeforeSuffix(iconResource, IconSize.SMALL.getSize()));
            }
        }
        if (image == null && (iconKey = this.getValue("SwingLargeIconKey")) instanceof Image) {
            image = (Image)iconKey;
        }
        return image;
    }

    public ResizableIcon getIcon() {
        String iconResource = (String)this.getValue(ICON_BASE);
        if (iconResource != null) {
            return ResizableIcons.fromResource(iconResource);
        }
        Icon small = (Icon)this.getValue("SmallIcon");
        Icon large = (Icon)this.getValue("SwingLargeIconKey");
        return ResizableIcons.binary(small, large);
    }

    public ResizableIcon getMenuIcon() {
        Object noIconInMenu = this.getValue(NO_ICON_IN_MENU);
        if (noIconInMenu == Boolean.TRUE) {
            return ResizableIcons.getEmpty();
        }
        return this.getIcon();
    }

    public boolean isSeparator() {
        return false;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String prefix) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        buffer.append(this.getText());
        buffer.append('\n');
        for (ActionItem child : this.getChildren()) {
            buffer.append(child.toString(prefix + "---"));
        }
        return buffer.toString();
    }

    public static class Compound
    extends ActionItem {
        private List<ActionItem> _children;

        public Compound() {
        }

        public Compound(Collection<ActionItem> children) {
            this._children = new ArrayList<ActionItem>(children);
        }

        @Override
        public ActionItem getActionDelegate() {
            for (ActionItem child : this.getChildren()) {
                if (child.getValue(ActionItem.DEFAULT_ACTION) != Boolean.TRUE) continue;
                return child;
            }
            return super.getActionDelegate();
        }

        @Override
        public List<ActionItem> getChildren() {
            if (this._children == null) {
                this._children = new ArrayList<ActionItem>();
            }
            return this._children;
        }

        @Override
        public void addChild(ActionItem item) {
            this.getChildren().add(item);
        }

        @Override
        public boolean hasChildren() {
            return this._children != null && this._children.size() > 0;
        }
    }

    private static class Component
    extends ActionItem {
        private JComponent _component;

        public Component(JComponent component) {
            this._component = component;
        }

        @Override
        public JComponent getComponent() {
            return this._component;
        }
    }

    private static class Separator
    extends ActionItem {
        @Override
        public boolean isSeparator() {
            return true;
        }
    }

    public static class Leaf
    extends ActionItem {
        private Action _action;

        public Leaf(Action action) {
            this._action = action;
        }

        @Override
        public Action getAction() {
            return this._action;
        }
    }
}

