/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import org.officelaf.OfficeLookAndFeelHelper;
import org.officelaf.OfficeRootPaneUI;
import org.openide.util.ImageUtilities;
import sun.swing.SwingUtilities2;

class OfficeTitlePane
extends JComponent {
    private static final Border HANDY_EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT;
    private static final int IMAGE_WIDTH;
    private static final float TITLE_FONT_SIZE_DEFAULT = 13.0f;
    private static final float TITLE_FONT_SIZE;
    Image windowImg;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon maximizeDownIcon;
    private Icon maximizeOverIcon;
    private Icon minimizeIcon;
    private Icon minimizeDownIcon;
    private Icon minimizeOverIcon;
    private Image systemIcon;
    private WindowListener windowListener;
    private Window window;
    private final JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private final OfficeRootPaneUI rootPaneUI;
    private final Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private final Color inactiveForeground = UIManager.getColor("inactiveCaptionText");
    private final Color inactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color activeBackground = null;
    private Color activeForeground = null;
    private Color activeShadow = null;
    boolean useOverrideState = false;
    int overrideState = 0;
    Rectangle storedBounds;
    boolean wasIconified = false;
    boolean isManualResize = false;

    public OfficeTitlePane(JRootPane root, OfficeRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.windowImg = ImageUtilities.loadImage((String)"org/officelaf/images/windowborder.png", (boolean)true);
        this.windowImg.getHeight(root);
        this.setPreferredSize(new Dimension(100, 30));
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
            this.updateSystemIcon();
            if (this.mustRemoveCloseButton()) {
                this.remove(this.closeButton);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.menuBar.setBackground(Color.RED);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private boolean mustRemoveCloseButton() {
        JDialog dialog;
        Window w = this.getWindow();
        return w != null && w instanceof JDialog && (dialog = (JDialog)w).getDefaultCloseOperation() == 0;
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
    }

    private void installDefaults() {
        this.setFont(OfficeLookAndFeelHelper.getSystemFont(1, 13.0f));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window w = this.getWindow();
        if (w != null) {
            if (w instanceof Frame) {
                System.setProperty("maltego.closeApp.setSaveInEDT", "true");
            }
            w.dispatchEvent(new WindowEvent(w, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if (this.useOverrideState) {
            this.useOverrideState = false;
            this.overrideState = 0;
            frame.setBounds(this.storedBounds);
            this.refreshState();
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        int mnemonic = OfficeTitlePane.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        mi = menu.add(this.iconifyAction);
        mnemonic = OfficeTitlePane.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mnemonic = OfficeTitlePane.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
        }
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mnemonic = OfficeTitlePane.getInt("MetalTitlePane.closeMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
    }

    private JButton createTitleButton() {
        JButton button = new JButton(){

            @Override
            public void updateUI() {
                this.setUI(new BasicButtonUI());
            }
        };
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(HANDY_EMPTY_BORDER);
        this.closeButton.putClientProperty("AccessibleName", "Close");
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.setPressedIcon(UIManager.getIcon("InternalFrame.closeDownIcon"));
        this.closeButton.setRolloverIcon(UIManager.getIcon("InternalFrame.closeOverIcon"));
        if (this.getWindowDecorationStyle() == 1) {
            this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.maximizeDownIcon = UIManager.getIcon("InternalFrame.maximizeDownIcon");
            this.maximizeOverIcon = UIManager.getIcon("InternalFrame.maximizeOverIcon");
            this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            this.minimizeDownIcon = UIManager.getIcon("InternalFrame.minimizeDownIcon");
            this.minimizeOverIcon = UIManager.getIcon("InternalFrame.minimizeOverIcon");
            this.iconifyButton = this.createTitleButton();
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.setText(null);
            this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.iconifyButton.setBorder(HANDY_EMPTY_BORDER);
            this.iconifyButton.putClientProperty("AccessibleName", "Iconify");
            this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
            this.iconifyButton.setPressedIcon(UIManager.getIcon("InternalFrame.iconifyDownIcon"));
            this.iconifyButton.setRolloverIcon(UIManager.getIcon("InternalFrame.iconifyOverIcon"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(HANDY_EMPTY_BORDER);
            this.toggleButton.putClientProperty("AccessibleName", "Maximize");
            this.toggleButton.setIcon(this.maximizeIcon);
            this.toggleButton.setPressedIcon(this.maximizeDownIcon);
            this.toggleButton.setRolloverIcon(this.maximizeOverIcon);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        this.closeButton.putClientProperty("paintActive", activeB);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    void refreshState() {
        this.setState(this.state, true);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            int usingState;
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            int n = usingState = this.useOverrideState ? this.overrideState : state;
            if (frame != null) {
                JRootPane rPane = this.getRootPane();
                if ((usingState & 6) != 0 && (rPane.getBorder() == null || rPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    this.rootPaneUI.installBorder(rPane);
                } else if ((usingState & 6) == 0) {
                    this.rootPaneUI.installBorder(rPane);
                }
                if (frame.isResizable()) {
                    if ((usingState & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon, this.minimizeDownIcon, this.minimizeOverIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon, this.maximizeDownIcon, this.maximizeOverIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon, Icon down, Icon over) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setPressedIcon(down);
        this.toggleButton.setRolloverIcon(over);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return (Frame)w;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        int xOffset;
        Color darkShadow;
        Color foreground;
        Color background;
        Frame frame = this.getFrame();
        if (frame != null) {
            this.setState(frame.getExtendedState());
        }
        JRootPane rPane = this.getRootPane();
        Window w = this.getWindow();
        boolean leftToRight = w == null ? rPane.getComponentOrientation().isLeftToRight() : w.getComponentOrientation().isLeftToRight();
        boolean isSelected = w == null || w.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        if (isSelected) {
            background = this.activeBackground;
            foreground = this.activeForeground;
            darkShadow = this.activeShadow;
        } else {
            background = this.inactiveBackground;
            foreground = this.inactiveForeground;
            darkShadow = this.inactiveShadow;
        }
        String key = "title-bar-color";
        String theTitle = this.getTitle();
        if ("Transform Seed Details".equals(theTitle)) {
            key = "hub-item-details-border-bg";
            theTitle = null;
        }
        int n = xOffset = leftToRight ? 5 : width - 5;
        if (this.getWindowDecorationStyle() == 1) {
            xOffset += leftToRight ? IMAGE_WIDTH + 5 : -IMAGE_WIDTH - 5;
        }
        int yOffset = 0;
        int titleLength = 0;
        int tx = 0;
        String iconPath = null;
        int xShift = 0;
        int yBound = 0;
        ImageIcon imgIcon = null;
        if (theTitle != null) {
            int titleW;
            g.setFont(g.getFont().deriveFont(TITLE_FONT_SIZE));
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)rPane, g);
            yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            titleLength = fm.stringWidth(theTitle);
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = w.getWidth() - w.getInsets().right - 2;
                }
                titleW = rect.x - xOffset - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rPane, fm, theTitle, titleW);
            } else {
                titleW = xOffset - rect.x - rect.width - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rPane, fm, theTitle, titleW);
                xOffset -= SwingUtilities2.stringWidth(rPane, fm, theTitle);
            }
            titleLength = SwingUtilities2.stringWidth(rPane, fm, theTitle);
            tx = (int)((float)width / 2.0f - (float)titleLength / 2.0f);
            if (theTitle != null) {
                switch (theTitle) {
                    case "Machine Manager": {
                        iconPath = "com/paterva/maltego/automation/resources/RobotManage.png";
                        break;
                    }
                    case "Transform Manager": {
                        iconPath = "com/paterva/maltego/transform/manager/resources/ManageTransforms.png";
                        break;
                    }
                    case "Entity Manager": {
                        iconPath = "com/paterva/maltego/entity/manager/resources/EntityManager.png";
                        break;
                    }
                    default: {
                        if (!(w instanceof Frame)) break;
                    }
                }
            }
            if (iconPath != null && (imgIcon = ImageUtilities.loadImageIcon(iconPath, (boolean)true)) != null) {
                xShift = imgIcon.getIconWidth() / 2;
                tx = (int)((float)tx + 1.5f * (float)xShift);
                yBound = height - imgIcon.getIconHeight() > this.getY() ? this.getY() + (height - imgIcon.getIconHeight()) / 2 : this.getY();
            }
        }
        Color titleBarColor = UIManager.getLookAndFeelDefaults().getColor(key);
        int iconX = (int)((float)tx - 2.5f * (float)xShift);
        boolean maltegoIdPlan = "true".equals(System.getProperty("maltego.titlebar.isMaltegoIdPlan", "false"));
        if (maltegoIdPlan) {
            int buffer = 15;
            int colorX1 = Math.max(0, (int)((float)iconX - 2.3f * (float)buffer));
            int colorX2 = Math.max(0, iconX - buffer);
            int colorX3 = Math.min(width, tx + titleLength + buffer);
            int colorX4 = Math.min(width, (int)((float)(tx + titleLength) + 2.3f * (float)buffer));
            g.setColor(titleBarColor);
            g.fillPolygon(new int[]{colorX1, colorX2, colorX3, colorX4}, new int[]{0, 29, 29, 0}, 4);
        } else {
            for (int i = 0; i < 30; ++i) {
                g.setColor(titleBarColor);
                g.drawLine(0, i, width, i);
            }
        }
        if (theTitle != null) {
            g.setColor(foreground);
            g.setColor(UIManager.getLookAndFeelDefaults().getColor("other-title-font-color"));
            if (theTitle != null) {
                switch (theTitle) {
                    case "Machine Manager": 
                    case "Transform Manager": 
                    case "Entity Manager": {
                        break;
                    }
                    default: {
                        if (!(w instanceof Frame)) break;
                        g.setColor(UIManager.getLookAndFeelDefaults().getColor("main-title-font-color"));
                    }
                }
            }
            if (iconPath != null && imgIcon != null) {
                imgIcon.paintIcon(rPane, g, iconX, yBound);
            }
            GraphicsUtil.setupTextAntialiasing((Graphics)g, (JComponent)rPane);
            SwingUtilities2.drawString((JComponent)rPane, g, theTitle, tx, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    private void updateSystemIcon() {
        Window w = this.getWindow();
        if (w == null) {
            this.systemIcon = null;
            return;
        }
        List<Image> icons = w.getIconImages();
        assert (icons != null);
        if (icons.isEmpty()) {
            this.systemIcon = null;
        } else if (icons.size() == 1) {
            this.systemIcon = icons.get(0);
        }
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Image getBackgroundImage() {
        return this.windowImg;
    }

    static {
        IMAGE_WIDTH = IMAGE_HEIGHT = IconSize.TINY.getSize();
        TITLE_FONT_SIZE = Math.min(Math.max((float)FontUtils.defaultScaled((float)2.0f).getSize(), 13.0f), 20.0f);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            OfficeTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            OfficeTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = OfficeTitlePane.this.getFrame();
                if (frame != null) {
                    OfficeTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    OfficeTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                OfficeTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                OfficeTitlePane.this.revalidate();
                OfficeTitlePane.this.repaint();
            } else if ("iconImage".equals(name)) {
                OfficeTitlePane.this.updateSystemIcon();
                OfficeTitlePane.this.revalidate();
                OfficeTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = OfficeTitlePane.this.rootPane.getFontMetrics(OfficeTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (OfficeTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = IMAGE_HEIGHT;
            }
            return Math.max(fontHeight, iconHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            int x;
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = OfficeTitlePane.this.window == null ? OfficeTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : OfficeTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = OfficeTitlePane.this.getWidth();
            if (OfficeTitlePane.this.closeButton != null && OfficeTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = OfficeTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = OfficeTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = IMAGE_HEIGHT;
                buttonWidth = IMAGE_WIDTH;
            }
            int y = OfficeTitlePane.this.getHeight() / 2 - buttonHeight / 2;
            int spacing = -15;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (OfficeTitlePane.this.menuBar != null) {
                OfficeTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 3;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (OfficeTitlePane.this.closeButton != null) {
                OfficeTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (OfficeTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && OfficeTitlePane.this.toggleButton.getParent() != null) {
                    spacing = 0;
                    OfficeTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (OfficeTitlePane.this.iconifyButton != null && OfficeTitlePane.this.iconifyButton.getParent() != null) {
                    spacing = 0;
                    OfficeTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
            OfficeTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (OfficeTitlePane.this.systemIcon != null) {
                g.drawImage(OfficeTitlePane.this.systemIcon, 0, 0, IMAGE_WIDTH, IMAGE_HEIGHT, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(IMAGE_WIDTH, size.width), Math.max(size.height, IMAGE_HEIGHT));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", OfficeTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OfficeTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", OfficeTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OfficeTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", OfficeTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OfficeTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", OfficeTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OfficeTitlePane.this.close();
        }
    }
}

