/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.AddPropertyFormController;
import com.paterva.maltego.util.ArrayUtilities;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.ImageTableCellRenderer;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.WeakListeners;

public abstract class PropertyTableModel
extends AbstractTableModel {
    private static final int COLUMN_NAME_COLUMN = 0;
    private static final int PROPERTY_DISPLAY_NAME_COLUMN = 1;
    private static final int PROPERTY_NAME_COLUMN = 2;
    private static final int PROPERTY_TYPE_COLUMN = 3;
    private static final String _newProperty = "New...";
    private static final Map<Object, Set<DisplayDescriptor>> _dynamicProperties = new HashMap<Object, Set<DisplayDescriptor>>();
    private TabularGraph _tabularGraph;
    private PropertyToColumnMap _map;
    private ETable _table;
    private TabularGraphListener _graphListener;
    private MapListener _mapListener;
    private boolean _createdDeleteButton = false;

    protected abstract String getSpecName(PropertyToColumnMap var1);

    protected abstract DisplayDescriptorCollection getTypeProperties(PropertyToColumnMap var1);

    protected abstract boolean isMapped(TabularGraph var1, String var2, PropertyDescriptor var3);

    public void setTabularGraph(TabularGraph table) {
        _dynamicProperties.clear();
        this._tabularGraph = table;
        this._graphListener = new TabularGraphListener();
        this._tabularGraph.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._graphListener, (Object)this._tabularGraph));
        this.createDeleteButton();
    }

    public TabularGraph getTabularGraph() {
        return this._tabularGraph;
    }

    public void setMap(PropertyToColumnMap map) {
        this._map = map;
        if (this._map != null) {
            this.removeUnusedDynamicProperties(this.getSpecName(this._map));
            this._mapListener = new MapListener();
            this._map.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._mapListener, (Object)this._map));
        }
        this.updatePropertyCombo();
        this.fireTableDataChanged();
    }

    public PropertyToColumnMap getMap() {
        return this._map;
    }

    public ETable getTable() {
        if (this._table == null) {
            this._table = new ETable((TableModel)this);
            this._table.setFillsViewportHeight(true);
            this._table.setSelectionMode(0);
            this._table.setDefaultRenderer(Image.class, (TableCellRenderer)new ImageTableCellRenderer());
        }
        return this._table;
    }

    protected String[] getColumnNames() {
        return new String[]{"Column", "Property", "Property Name", "Property Type"};
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumnNames()[column];
    }

    @Override
    public int getRowCount() {
        if (this._tabularGraph == null || this._map == null) {
            return 0;
        }
        return this._map.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._tabularGraph == null || this._map == null) {
            return null;
        }
        PropertyDescriptor pd = this._map.getProperty(this._map.getColumns()[rowIndex]);
        switch (columnIndex) {
            case 0: {
                return this._tabularGraph.getColumnNames()[this._map.getColumns()[rowIndex]];
            }
            case 1: {
                return pd != null ? pd.getDisplayName() : "";
            }
            case 2: {
                return pd != null ? pd.getName() : "";
            }
            case 3: {
                if (pd != null) {
                    return TypeRegistry.getDefault().getType(pd.getType()).getTypeName();
                }
                return "";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            int tabularGraphColumn = this._map.getColumns()[rowIndex];
            PropertyDescriptor pd = null;
            if (value instanceof PropertyDescriptor) {
                pd = (PropertyDescriptor)value;
            } else if (value == _newProperty) {
                pd = this.createDynamicProperty();
            }
            this._map.put(tabularGraphColumn, pd);
        }
    }

    protected PropertyDescriptor createDynamicProperty() {
        DisplayDescriptor pd = null;
        EditDialogDescriptor vd = new EditDialogDescriptor("Add New Property", (WizardDescriptor.Panel)new AddPropertyFormController());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)vd) == EditDialogDescriptor.OK_OPTION) {
            String name = (String)vd.getProperty("uniqueName");
            TypeDescriptor type = (TypeDescriptor)vd.getProperty("typeDescriptor");
            String displayName = (String)vd.getProperty("displayName");
            pd = new DisplayDescriptor(type.getType(), name, displayName);
            if (Date.class.equals((Object)pd.getTypeDescriptor().getType())) {
                pd.setFormat((Format)new SimpleDateFormat("yyyy/MM/dd"));
            }
            this.addDynamicProperty(pd);
        }
        return pd;
    }

    protected void addDynamicProperty(DisplayDescriptor pd) {
        Set<DisplayDescriptor> pds = _dynamicProperties.get(this.getSpecName(this._map));
        if (pds == null) {
            pds = new HashSet<DisplayDescriptor>();
            _dynamicProperties.put(this.getSpecName(this._map), pds);
        }
        pds.add(pd);
        this.updatePropertyCombo();
    }

    protected void updatePropertyCombo() {
        if (this._tabularGraph != null && this._map != null) {
            TableColumn propertyColumn = this._table.getColumnModel().getColumn(1);
            DisplayDescriptorCollection properties = this.getTypeProperties(this._map);
            Set<DisplayDescriptor> dynamicProperties = _dynamicProperties.get(this.getSpecName(this._map));
            HashSet<DisplayDescriptor> comboProperties = new HashSet<DisplayDescriptor>();
            if (properties != null) {
                comboProperties.addAll((Collection<DisplayDescriptor>)properties);
            }
            if (dynamicProperties != null) {
                comboProperties.addAll(dynamicProperties);
            }
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("");
            for (DisplayDescriptor dd : comboProperties) {
                comboBox.addItem((String)dd);
            }
            comboBox.addItem(_newProperty);
            propertyColumn.setCellEditor(new DefaultCellEditor(comboBox));
        }
    }

    protected void createDeleteButton() {
        if (this._createdDeleteButton) {
            return;
        }
        EditableTableDecorator decorator = new EditableTableDecorator();
        decorator.addEditDelete((JTable)this._table, new TableButtonListener(){

            public void actionPerformed(TableButtonEvent evt) {
                int[] selectedRows = evt.getSelectedRows();
                ArrayList<Integer> columns = new ArrayList<Integer>(selectedRows.length);
                for (int row : selectedRows) {
                    columns.add(PropertyTableModel.this._map.getColumns()[PropertyTableModel.this._table.convertRowIndexToModel(row)]);
                }
                Integer[] columnsArray = columns.toArray(new Integer[columns.size()]);
                PropertyTableModel.this._tabularGraph.removeColumnsFromEntities(ArrayUtilities.toPrimitiveArray((Integer[])columnsArray));
            }
        }, null);
        this._createdDeleteButton = true;
    }

    protected void removeUnusedDynamicProperties(String specName) {
        Set<DisplayDescriptor> dds = _dynamicProperties.get(specName);
        if (dds == null) {
            return;
        }
        Iterator<DisplayDescriptor> it = dds.iterator();
        while (it.hasNext()) {
            DisplayDescriptor dd = it.next();
            if (this.isMapped(this._tabularGraph, specName, (PropertyDescriptor)dd)) continue;
            it.remove();
        }
    }

    protected class MapListener
    implements PropertyChangeListener {
        protected MapListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("mappingChanged".equals(evt.getPropertyName())) {
                PropertyTableModel.this.fireTableDataChanged();
            }
        }
    }

    protected class TabularGraphListener
    implements PropertyChangeListener {
        protected TabularGraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("columnNamesChanged".equals(evt.getPropertyName())) {
                PropertyTableModel.this.fireTableDataChanged();
            } else if ("columnRemoved".equals(evt.getPropertyName())) {
                PropertyTableModel.this.fireTableDataChanged();
            }
        }
    }
}

