/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.html;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.detailview.html.DetailViewRenderContext;
import com.paterva.maltego.detailview.html.HtmlDetailViewRenderer;
import com.paterva.maltego.detailview.html.HtmlSelectListener;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.util.ui.fonts.FontSizeRegistry;
import com.paterva.maltego.util.ui.privacymode.PrivacyMode;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Reader;
import java.io.StringReader;
import java.net.Proxy;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HtmlDetailView
extends JPanel {
    private static final Logger LOG = Logger.getLogger(HtmlDetailView.class.getName());
    private static final String DOC_URL = "http://localhost/com.paterva.maltego";
    private static final Logger _loboLogger = Logger.getLogger("org.lobobrowser");
    private final HtmlPanel _htmlPanel;
    private final DocumentBuilderImpl _docBuilder;
    private final DetailViewRenderContext _renderContext;
    private PropertyChangeListener _pcl = null;
    private PropertyChangeListener _partListener = null;
    private GraphLifeCycleListener _graphListener;

    public HtmlDetailView() {
        this.initComponents();
        _loboLogger.setLevel(Level.SEVERE);
        this._htmlPanel = new HtmlPanel();
        this._htmlPanel.setFocusable(false);
        AllowToggleUserAgentContext ucontext = new AllowToggleUserAgentContext();
        this._renderContext = new DetailViewRenderContext(this._htmlPanel, (UserAgentContext)ucontext);
        this._docBuilder = new DocumentBuilderImpl((UserAgentContext)ucontext, (HtmlRendererContext)this._renderContext);
        this.add((Component)this._htmlPanel, "Center");
        Color bg = UIManager.getLookAndFeelDefaults().getColor("detail-view-empty-bg");
        this.setBackground(bg);
        this.warmup();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._pcl = new UpdateFontSizePropertyChangeListner();
        FontSizeRegistry.getDefault().addPropertyChangeListener(this._pcl);
        this._graphListener = new GraphLifeCycleListener();
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this._graphListener);
    }

    @Override
    public void removeNotify() {
        GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this._graphListener);
        this._graphListener = null;
        super.removeNotify();
        FontSizeRegistry.getDefault().removePropertyChangeListener(this._pcl);
        this._pcl = null;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void warmup() {
        this.showEmptyDocument();
    }

    public void setSelectedPart(GraphPart part) {
        LOG.log(Level.FINE, "Set selected part: {0}", part);
        GraphPart oldPart = this._renderContext.getSelectedPart();
        if (!Utilities.compareObjects((Object)oldPart, (Object)part)) {
            if (oldPart != null) {
                this.removeListeners(oldPart);
            }
            if (part != null) {
                this._renderContext.setSelectedPart(part);
                this.updateView(part);
                this.addListeners(part);
            } else {
                this._renderContext.setSelectedPart(null);
                this.showEmptyDocument();
            }
        }
    }

    public void addHtmlSelectListener(HtmlSelectListener listener) {
        this._renderContext.addHtmlSelectListener(listener);
    }

    public void removeHtmlSelectListener(HtmlSelectListener listener) {
        this._renderContext.removeHtmlSelectListener(listener);
    }

    private void addListeners(GraphPart viewOrModelPart) {
        this._partListener = new PartChangeListener(viewOrModelPart);
        GraphID graphID = viewOrModelPart.getGraphID();
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        view.getGraphStructureStore().addPropertyChangeListener(this._partListener);
        view.getGraphDataStore().addPropertyChangeListener(this._partListener);
    }

    private void removeListeners(GraphPart viewOrModelPart) {
        GraphID graphID = viewOrModelPart.getGraphID();
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            view.getGraphStructureStore().removePropertyChangeListener(this._partListener);
            view.getGraphDataStore().removePropertyChangeListener(this._partListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._partListener = null;
    }

    private void updateView(GraphPart part) {
        try {
            if (GraphStoreRegistry.getDefault().isExistingAndOpen(part.getGraphID())) {
                String html = HtmlDetailViewRenderer.getDefault().render(part);
                this.updateView(html);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateView(String html) {
        Document document = this.createDocument(html);
        this.showDocument(document);
    }

    private void showDocument(Document document) {
        if (document != null) {
            this._htmlPanel.setDocument(document, (HtmlRendererContext)this._renderContext);
            this._htmlPanel.revalidate();
        }
    }

    private void showEmptyDocument() {
        Document document = this.createDocument(HtmlDetailViewRenderer.getDefault().renderEmpty());
        this.showDocument(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDocument(String html) {
        Document document = null;
        try (StringReader reader = new StringReader(html);){
            document = this._docBuilder.parse((InputSource)new InputSourceImpl((Reader)reader, DOC_URL));
        }
        return document;
    }

    private class GraphLifeCycleListener
    implements PropertyChangeListener {
        private GraphLifeCycleListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphPart part;
            if ("graphClosing".equals(evt.getPropertyName()) && (part = HtmlDetailView.this._renderContext.getSelectedPart()) != null && part.getGraphID().equals((Object)((GraphID)evt.getNewValue()))) {
                HtmlDetailView.this.setSelectedPart(null);
            }
        }
    }

    private class PartChangeListener
    implements PropertyChangeListener {
        private final GraphPart _part;

        public PartChangeListener(GraphPart part) {
            this._part = part;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                GraphID graphID = this._part.getGraphID();
                Guid partID = this._part.getID();
                Object changes = evt.getNewValue();
                boolean update = false;
                if (changes instanceof GraphDataMods) {
                    GraphDataMods dataMods = (GraphDataMods)changes;
                    if (partID instanceof EntityID) {
                        GraphStoreView view;
                        Set modelEntities;
                        EntityID entityID = (EntityID)partID;
                        update = dataMods.getEntitiesUpdated().containsKey(entityID);
                        if (!update && (modelEntities = (view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID)).getModelViewMappings().getModelEntities(entityID)) != null && modelEntities.size() > 1) {
                            update = !Collections.disjoint(dataMods.getEntitiesUpdated().keySet(), modelEntities);
                        }
                    } else if (partID instanceof LinkID) {
                        LinkID linkID = (LinkID)partID;
                        update = dataMods.getLinksUpdated().containsKey(linkID);
                    }
                } else if (changes instanceof GraphStructureMods) {
                    GraphStructureMods structureMods = (GraphStructureMods)changes;
                    if (partID instanceof EntityID) {
                        EntityID entityID = (EntityID)partID;
                        boolean bl = update = structureMods.getCollectionMods().containsKey(entityID) || structureMods.getEntitiesPinned().contains(entityID) || structureMods.getEntitiesUnpinned().contains(entityID);
                    }
                }
                if (update) {
                    HtmlDetailView.this._renderContext.setSelectedPart(this._part);
                    HtmlDetailView.this.updateView(this._part);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class UpdateFontSizePropertyChangeListner
    implements PropertyChangeListener {
        private UpdateFontSizePropertyChangeListner() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphPart selectedPart = HtmlDetailView.this._renderContext.getSelectedPart();
            if (selectedPart != null) {
                HtmlDetailView.this.updateView(selectedPart);
            }
        }
    }

    private static class AllowToggleUserAgentContext
    extends SimpleUserAgentContext {
        private AllowToggleUserAgentContext() {
        }

        protected Proxy getProxy() {
            return null;
        }

        public String[] getAllowedScriptURIs() {
            return new String[]{HtmlDetailView.DOC_URL};
        }

        public String[] getAllowedScriptFunctions() {
            return new String[]{HtmlDetailViewRenderer.TOGGLE_FUNC};
        }

        public String[] getAllowedScriptEvents() {
            return new String[]{"onclick"};
        }

        public String[] getAllowedScriptEventFuntionCalls() {
            return new String[]{"toggle(this)"};
        }

        public boolean isExternalCSSEnabled() {
            return !PrivacyMode.STEALTH.equals((Object)PrivacyModeSettings.getInstance().getPrivacyMode());
        }

        public boolean isExternalScriptsEnabled() {
            return false;
        }
    }
}

