/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.api.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.paterva.maltego.util.StringUtilities;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpProxyExceptionUtils {
    public static final String CODE_STRING = "Code:";
    private static final Logger LOG = Logger.getLogger(HttpProxyExceptionUtils.class.getName());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void parseForPotentialResponseErrors(Map<String, List<String>> headers, String content) throws RuntimeException {
        if (headers != null && !StringUtilities.isNullOrEmpty((String)content)) {
            Set<String> errors;
            String contentType;
            List<String> contentTypeList = headers.get("content-type");
            if (contentTypeList == null || contentTypeList.isEmpty()) {
                contentTypeList = headers.get("Content-Type");
            }
            if (contentTypeList != null && !contentTypeList.isEmpty() && (contentType = contentTypeList.get(0)) != null && contentType.contains("json") && (contentType.contains("application/") || contentType.contains("text/")) && !(errors = HttpProxyExceptionUtils.parsePotentialResponseErrors(content, true)).isEmpty()) {
                String errMsg = String.join((CharSequence)"\n", errors);
                throw new RuntimeException(errMsg);
            }
        }
    }

    public static Set<String> parsePotentialResponseErrors(String jsonContent, boolean log) {
        Map jsonMap;
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        if (StringUtilities.isNullOrEmpty((String)jsonContent)) {
            return errors;
        }
        try {
            jsonMap = (Map)objectMapper.readValue(jsonContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException ex) {
            if (log) {
                LOG.log(Level.WARNING, "Failed to parse JSON response: {0}", jsonContent);
            }
            return errors;
        }
        if (jsonMap == null) {
            return errors;
        }
        Object statusObj = jsonMap.get("status");
        if (!HttpProxyExceptionUtils.checkIfMap(statusObj)) {
            return errors;
        }
        Map statusMap = (Map)statusObj;
        if (statusMap == null) {
            return errors;
        }
        Object uiMessagesObj = statusMap.get("uiMessages");
        if (!HttpProxyExceptionUtils.checkIfList(uiMessagesObj)) {
            return errors;
        }
        List uiMessages = (List)uiMessagesObj;
        if (uiMessages == null) {
            return errors;
        }
        for (Map uiMessage : uiMessages) {
            String errorText;
            if (!"FatalError".equals(uiMessage.get("type")) || (errorText = (String)uiMessage.get("text")) == null) continue;
            errors.add(errorText);
        }
        Object codeObj = statusMap.get("code");
        if (codeObj instanceof Integer) {
            LinkedHashSet<String> errorsWithCode = new LinkedHashSet<String>();
            for (String error : errors) {
                String newError = error + (error.trim().endsWith(".") ? "" : ".") + " " + CODE_STRING + " " + codeObj;
                errorsWithCode.add(newError);
            }
            return errorsWithCode;
        }
        return errors;
    }

    private static boolean checkIfMap(Object obj) {
        return obj instanceof Map;
    }

    private static boolean checkIfList(Object obj) {
        return obj instanceof List;
    }
}

