/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractBodyParser;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyType;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.IHttpHeader;

final class SimpleMessageBodyParser
extends AbstractBodyParser {
    private static final Logger LOG = Logger.getLogger(SimpleMessageBodyParser.class.getName());
    private int received;

    public SimpleMessageBodyParser(AbstractHttpConnection httpConnection, IHttpHeader header) throws IOException {
        super(BodyType.SIMPLE_MESSAGE, httpConnection, header);
    }

    void doParse(ComposedByteBuffer rawData) throws IOException {
        int read = rawData.drain(this);
        this.received += read;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getConnectionId() + "] received data (total received = " + this.received + " bytes)");
        }
    }

    void onException(IOException ioe, ComposedByteBuffer rawData) {
        if (!(ioe instanceof ClosedChannelException) && LOG.isLoggable(Level.FINE)) {
            LOG.fine("error occured by parsing simple message " + ioe.toString());
        }
    }

    void onDisconnect() {
        this.setPersistent(false);
        this.setComplete();
        super.onDisconnect();
    }
}

