/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.utils.time;

import com.pinkmatter.utils.time.HumanTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static long getDurationMillis(String duration, long defaultDuration) {
        HumanTime ht = HumanTime.eval(duration);
        long delta = ht.getDelta();
        if (delta == 0L) {
            return defaultDuration;
        }
        return delta;
    }

    public static String exactly(long duration) {
        return HumanTime.exactly(duration);
    }

    public static Date getDateUtc(int year, int month, int day, int hour, int minute, int second) {
        return TimeUtils.getDate(TimeZone.getTimeZone("UTC"), year, month, day, hour, minute, second);
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second) {
        return TimeUtils.getDate(TimeZone.getDefault(), year, month, day, hour, minute, second);
    }

    public static Date updateTime(Date date, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Date addTime(Date date, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, hour);
        c.add(12, minute);
        c.add(13, second);
        return c.getTime();
    }

    public static Date getTimeUtc(int hour, int minute, int second) {
        return TimeUtils.getDate(TimeZone.getTimeZone("UTC"), hour, minute, second);
    }

    public static Date getTime(int hour, int minute, int second) {
        return TimeUtils.getDate(TimeZone.getDefault(), hour, minute, second);
    }

    public static Date getRelative(int hour, int minute, int second) {
        return TimeUtils.getRelativeDate(TimeZone.getDefault(), hour, minute, second);
    }

    public static Date getRelative(int minute, int second) {
        return TimeUtils.getRelativeDate(TimeZone.getDefault(), 0, minute, second);
    }

    public static Date getRelative(int second) {
        return TimeUtils.getRelativeDate(TimeZone.getDefault(), 0, 0, second);
    }

    public static Date getRelativeUtc(int hour, int minute, int second) {
        return TimeUtils.getRelativeDate(TimeZone.getTimeZone("UTC"), hour, minute, second);
    }

    public static Date getRelativeUtc(int minute, int second) {
        return TimeUtils.getRelativeDate(TimeZone.getTimeZone("UTC"), 0, minute, second);
    }

    public static Date getRelativeUtc(int second) {
        return TimeUtils.getRelativeDate(TimeZone.getTimeZone("UTC"), 0, 0, second);
    }

    private static Date getRelativeDate(TimeZone tz, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance(tz);
        c.add(11, hour);
        c.add(12, minute);
        c.add(13, second);
        return c.getTime();
    }

    private static Date getDate(TimeZone tz, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance(tz);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    private static Date getDate(TimeZone tz, int year, int month, int day, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance(tz);
        c.set(year, month, day, hour, minute, second);
        return c.getTime();
    }

    public static int getUTCOffset(double longitude) {
        return (int)Math.round(longitude / 15.0);
    }
}

