/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.propertyview.DisplayInfoFormController;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.util.Collections;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class EditPropertyMappingsAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        if (nodes != null && nodes.length > 0) {
            MaltegoEntity entity = (MaltegoEntity)nodes[0].getLookup().lookup(MaltegoEntity.class);
            GraphEntity graphEntity = (GraphEntity)nodes[0].getLookup().lookup(GraphEntity.class);
            if (entity != null && graphEntity != null) {
                GraphID graphID = graphEntity.getGraphID();
                MaltegoEntity entityBefore = entity.createClone();
                EditDialogDescriptor vd = new EditDialogDescriptor("Edit Property Mappings", (WizardDescriptor.Panel)new DisplayInfoFormController());
                vd.putProperty("entity", (Object)entity);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)vd) == EditDialogDescriptor.OK_OPTION) {
                    String description = "Change property mappings of " + GraphTransactionHelper.getDescriptionForEntities((GraphID)graphID, Collections.singleton(entityBefore), (boolean)true);
                    if (!entity.isCopy((MaltegoPart)entityBefore)) {
                        ModifiedHelper.updateModified((String)GraphUser.getUser((GraphID)graphID), (MaltegoPart)entity);
                    }
                    GraphTransactionHelper.doEntityChanged((GraphID)graphID, (SimilarStrings)new SimilarStrings(description), (MaltegoEntity)entityBefore, (MaltegoEntity)entity);
                }
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes != null && nodes.length == 1) {
            MaltegoEntity entity = (MaltegoEntity)nodes[0].getLookup().lookup(MaltegoEntity.class);
            return entity != null;
        }
        return false;
    }

    public String getName() {
        return "Add Property...";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return "com/paterva/maltego/propertyview/PropertyMapping.png";
    }
}

