/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityDecorator;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.util.Collection;
import org.openide.util.Lookup;

public class ExtensibleEntityFactory
extends EntityFactory.Registry {
    private final GraphID _graphID;
    private final Collection<? extends EntityDecorator> _decorators = Lookup.getDefault().lookupAll(EntityDecorator.class);

    public ExtensibleEntityFactory(EntityRegistry registry, GraphID graphID) {
        super(registry);
        this._graphID = graphID;
    }

    @Override
    public MaltegoEntity createInstance(MaltegoEntitySpec descriptor, boolean sampleInstance, EntityID id, boolean decorate) throws TypeInstantiationException {
        MaltegoEntity entity = super.createInstance(descriptor, sampleInstance, id, decorate);
        entity = this.decorate(entity, decorate);
        return entity;
    }

    @Override
    public MaltegoEntity createInstance(MaltegoEntitySpec descriptor, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
        MaltegoEntity entity = super.createInstance(descriptor, sampleInstance, decorate);
        entity = this.decorate(entity, decorate);
        return entity;
    }

    @Override
    public MaltegoEntity createInstance(String typeName, boolean sampleInstance, EntityID id, boolean decorate) throws TypeInstantiationException {
        MaltegoEntity entity = super.createInstance(typeName, sampleInstance, id, decorate);
        entity = this.decorate(entity, decorate);
        return entity;
    }

    @Override
    public MaltegoEntity createInstance(String typeName, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
        MaltegoEntity entity = super.createInstance(typeName, sampleInstance, decorate);
        entity = this.decorate(entity, decorate);
        return entity;
    }

    private MaltegoEntity decorate(MaltegoEntity entity, boolean decorate) {
        if (decorate && this._graphID != null) {
            for (EntityDecorator entityDecorator : this._decorators) {
                entity = entityDecorator.decorate(this._graphID, entity);
            }
        }
        return entity;
    }
}

