/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputReadNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputStartsWithNodeGen;

public abstract class InputStartsWithNode
extends Node {
    public static InputStartsWithNode create() {
        return InputStartsWithNodeGen.create();
    }

    public abstract boolean execute(Object var1, Object var2, Object var3);

    @Specialization(guards={"mask == null"})
    public boolean doBytes(byte[] input, byte[] prefix, Object mask) {
        return ArrayUtils.regionEqualsWithOrMask((byte[])input, (int)0, (byte[])prefix, (int)0, (int)prefix.length, null);
    }

    @Specialization(guards={"mask != null"})
    public boolean doBytesMask(byte[] input, byte[] prefix, byte[] mask) {
        return ArrayUtils.regionEqualsWithOrMask((byte[])input, (int)0, (byte[])prefix, (int)0, (int)prefix.length, (byte[])mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean doString(String input, String prefix, Object mask) {
        return input.startsWith(prefix);
    }

    @Specialization(guards={"mask != null"})
    public boolean doStringMask(String input, String prefix, String mask) {
        return ArrayUtils.regionEqualsWithOrMask((String)input, (int)0, (String)prefix, (int)0, (int)mask.length(), (String)mask);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask == null"})
    public boolean doTruffleObjBytes(Object input, byte[] prefix, Object mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputStartsWithNode.startsWithTruffleObj(input, prefix, null, lengthNode, charAtNode);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask != null"})
    public boolean doTruffleObjBytesMask(Object input, byte[] prefix, byte[] mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        assert (mask.length == prefix.length);
        return InputStartsWithNode.startsWithTruffleObj(input, prefix, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask == null"})
    public boolean doTruffleObjString(Object input, String prefix, Object mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputStartsWithNode.startsWithTruffleObj(input, prefix, null, lengthNode, charAtNode);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask != null"})
    public boolean doTruffleObjStringMask(Object input, String prefix, String mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        assert (mask.length() == prefix.length());
        return InputStartsWithNode.startsWithTruffleObj(input, prefix, mask, lengthNode, charAtNode);
    }

    private static boolean startsWithTruffleObj(Object input, byte[] prefix, byte[] mask, InputLengthNode lengthNode, InputReadNode charAtNode) {
        if (lengthNode.execute(input) < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (InputReadNode.readWithMask(input, i, mask, i, charAtNode) == Byte.toUnsignedInt(prefix[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithTruffleObj(Object input, String prefix, String mask, InputLengthNode lengthNode, InputReadNode charAtNode) {
        if (lengthNode.execute(input) < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (InputReadNode.readWithMask(input, i, mask, i, charAtNode) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean neitherByteArrayNorString(Object obj) {
        return !(obj instanceof byte[]) && !(obj instanceof String);
    }
}

