/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import org.officelaf.util.CommandButtonPainter;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonListener;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;

public class OfficeCommandButtonUI
extends BasicCommandButtonUI {
    static final Color SEPARATOR_COLOR = new Color(13942912);
    protected CommandButtonPainter painter;
    private boolean disabledIconCached = false;
    private BufferedImage buttonIconCache;

    public static ComponentUI createUI(JComponent c) {
        return new OfficeCommandButtonUI();
    }

    protected boolean hasPopup() {
        return this.popupActionIcon != null;
    }

    protected void installDefaults() {
        this.commandButton.setFont(UIManager.getLookAndFeelDefaults().getFont("ribbon-button-font"));
        super.installDefaults();
        this.painter = new CommandButtonPainter(this.commandButton);
        this.commandButton.setBorder((Border)new BorderUIResource.EmptyBorderUIResource(3, 3, 3, 3));
        this.commandButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("icon".equals(evt.getPropertyName())) {
                    OfficeCommandButtonUI.this.buttonIconCache = null;
                }
            }
        });
    }

    protected BasicCommandButtonListener createButtonListener(AbstractCommandButton b) {
        return new BasicCommandButtonListener(){

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
            }
        };
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        this.painter.paintBackground(graphics, toFill);
    }

    protected void paintButtonHorizontalSeparator(Graphics g, Rectangle rect) {
        g.setColor(SEPARATOR_COLOR);
        g.drawLine(1, rect.y, this.commandButton.getBounds().width - 2, rect.y);
    }

    protected void paintButtonVerticalSeparator(Graphics g, Rectangle separatorArea) {
        g.setColor(SEPARATOR_COLOR);
        g.drawLine(separatorArea.x, 1, separatorArea.x, this.commandButton.getBounds().height - 2);
    }

    protected ResizableIcon createPopupActionIcon() {
        return new PopupArrowIcon(((JCommandButton)this.commandButton).getPopupOrientationKind());
    }

    protected void paintPopupActionIcon(Graphics g, Rectangle rect) {
        boolean popupEnabled = this.commandButton instanceof JCommandButton && ((JCommandButton)this.commandButton).getPopupModel().isEnabled();
        Graphics2D g2d = (Graphics2D)g.create();
        if (!popupEnabled) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        this.popupActionIcon.paintIcon((Component)this.commandButton, (Graphics)g2d, rect.x, rect.y);
        g2d.dispose();
    }

    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        ResizableIcon iconToPaint;
        boolean disabled = this.toUseDisabledIcon();
        ResizableIcon resizableIcon = iconToPaint = disabled && this.commandButton.getDisabledIcon() != null ? this.commandButton.getDisabledIcon() : this.commandButton.getIcon();
        if (iconRect == null || iconToPaint == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        int width = iconToPaint.getIconWidth();
        int height = iconToPaint.getIconHeight();
        if (this.buttonIconCache == null || this.disabledIconCached != disabled || this.buttonIconCache.getWidth() != width || this.buttonIconCache.getHeight() != height) {
            this.buttonIconCache = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            Graphics2D ig = this.buttonIconCache.createGraphics();
            iconToPaint.paintIcon((Component)this.commandButton, ig, 0, 0);
            ig.dispose();
            this.disabledIconCached = disabled;
        }
        g2d.drawImage((Image)this.buttonIconCache, iconRect.x, iconRect.y, null);
    }

    protected int getLayoutGap() {
        return 2;
    }

    protected Color getForegroundColor(boolean isTextPaintedEnabled) {
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        return laf.getColor(isTextPaintedEnabled ? "ribbon-button-text-color" : "ribbon-button-disabled-text-color");
    }

    public static class PopupArrowIcon
    implements ResizableIcon {
        private static final Color C = UIManager.getLookAndFeelDefaults().getColor("ribbon-button-text-color");
        private static final Dimension TRIANGLE = new Dimension(5, 3);
        private final Dimension dim = new Dimension();
        private final JCommandButton.CommandButtonPopupOrientationKind orientationKind;

        public PopupArrowIcon(JCommandButton.CommandButtonPopupOrientationKind orientationKind) {
            this.orientationKind = orientationKind;
        }

        public void setDimension(Dimension newDimension) {
            this.dim.width = newDimension.width;
            this.dim.height = newDimension.height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            int xx = this.dim.width > PopupArrowIcon.TRIANGLE.width ? x + this.dim.width / 2 - PopupArrowIcon.TRIANGLE.width / 2 : x;
            int yy = this.dim.height > PopupArrowIcon.TRIANGLE.height ? y + this.dim.height / 2 - PopupArrowIcon.TRIANGLE.height / 2 : y;
            Composite old = g2d.getComposite();
            g2d.translate(0, 1);
            g2d.setComposite(old);
            g2d.translate(0, -1);
            g2d.setColor(C);
            this.drawTriangle(g2d, xx, yy);
        }

        private void drawTriangle(Graphics2D g, int x, int y) {
            if (this.orientationKind == JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD) {
                g.drawLine(x, y, x + 4, y);
                g.drawLine(x + 1, y + 1, x + 3, y + 1);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
            } else {
                g.drawLine(x, y, x, y + 4);
                g.drawLine(x + 1, y + 1, x + 1, y + 3);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
            }
        }

        public int getIconWidth() {
            return this.dim.width;
        }

        public int getIconHeight() {
            return this.dim.height;
        }
    }
}

