/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.home;

import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.welcome.home.HomeTopComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class HomeAndGraphTopComponentRegistry
implements PropertyChangeListener {
    public static final String PROP_TOPMOST = "topmost";
    private final PropertyChangeSupport _support = new PropertyChangeSupport(this);
    private TopComponent _topMost;
    private TopComponent.Registry _registry = TopComponent.getRegistry();

    HomeAndGraphTopComponentRegistry() {
        this._registry.addPropertyChangeListener((PropertyChangeListener)this);
        TopComponent active = HomeAndGraphTopComponentRegistry.asGraphOrHomeEditor(this._registry.getActivated());
        if (active != null) {
            this._topMost = active;
        } else {
            for (TopComponent tc : this._registry.getOpened()) {
                if (!HomeAndGraphTopComponentRegistry.isGraphOrHomeEditor(tc)) continue;
                this._topMost = tc;
                break;
            }
        }
    }

    public TopComponent getTopmost() {
        return this._topMost;
    }

    private void setTopmost(TopComponent tc) {
        if (this._topMost != tc) {
            TopComponent old = this._topMost;
            this._topMost = tc;
            this.firePropertyChanged(PROP_TOPMOST, old, this._topMost);
        }
    }

    public TopComponent getActive() {
        TopComponent active = this._registry.getActivated();
        if (HomeAndGraphTopComponentRegistry.isGraphOrHomeEditor(active)) {
            return active;
        }
        return null;
    }

    public Set<TopComponent> getOpen() {
        HashSet<TopComponent> open = new HashSet<TopComponent>();
        for (TopComponent tc : this._registry.getOpened()) {
            if (!HomeAndGraphTopComponentRegistry.isGraphOrHomeEditor(tc)) continue;
            open.add(tc);
        }
        return open;
    }

    public static boolean isGraphEditor(TopComponent tc) {
        return tc != null && tc.getLookup().lookup(GraphDataObject.class) != null;
    }

    public static boolean isHome(TopComponent tc) {
        return tc instanceof HomeTopComponent;
    }

    public static boolean isGraphOrHomeEditor(TopComponent tc) {
        return HomeAndGraphTopComponentRegistry.isHome(tc) || HomeAndGraphTopComponentRegistry.isGraphEditor(tc);
    }

    private static TopComponent asGraphOrHomeEditor(TopComponent tc) {
        if (HomeAndGraphTopComponentRegistry.isGraphOrHomeEditor(tc)) {
            return tc;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String type = evt.getPropertyName();
        if ("activated".equals(type)) {
            TopComponent newActive = (TopComponent)evt.getNewValue();
            TopComponent oldActive = (TopComponent)evt.getOldValue();
            if (HomeAndGraphTopComponentRegistry.isGraphOrHomeEditor(newActive)) {
                this.setTopmost(newActive);
            } else if (HomeAndGraphTopComponentRegistry.isGraphOrHomeEditor(oldActive) && WindowManager.getDefault().isEditorTopComponent(newActive)) {
                this.setTopmost(null);
            }
        } else if ("tcClosed".equals(type)) {
            TopComponent tc = (TopComponent)evt.getNewValue();
            boolean foundEditor = false;
            for (TopComponent openTC : this._registry.getOpened()) {
                if (!WindowManager.getDefault().isEditorTopComponent(openTC)) continue;
                foundEditor = true;
                break;
            }
            if (tc == this._topMost && !foundEditor) {
                this.setTopmost(null);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._support.removePropertyChangeListener(pcl);
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._support.firePropertyChange(property, oldValue, newValue);
    }
}

