/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

public class MaltegoHelper {
    public static String getCountry() {
        return MaltegoHelper.getPropertyNonNull("user.country");
    }

    public static String getOSArch() {
        return MaltegoHelper.getPropertyNonNull("os.arch");
    }

    public static String getOSName() {
        return MaltegoHelper.getPropertyNonNull("os.name");
    }

    public static String getOSVersion() {
        return MaltegoHelper.getPropertyNonNull("os.version");
    }

    public static String getOSPatchLevel() {
        return MaltegoHelper.getPropertyNonNull("sun.os.patch.level");
    }

    public static String getJavaVersion() {
        return MaltegoHelper.getPropertyNonNull("java.version");
    }

    public static boolean isPreJava8(String javaVersion) {
        return javaVersion.startsWith("1.") && !MaltegoHelper.isJava8(javaVersion);
    }

    public static boolean isJava8(String javaVersion) {
        return javaVersion.startsWith("1.8.");
    }

    public static boolean isJava9(String javaVersion) {
        return javaVersion.startsWith("9.");
    }

    public static boolean isJava10(String javaVersion) {
        return javaVersion.startsWith("10.");
    }

    public static boolean isJava11(String javaVersion) {
        return javaVersion.startsWith("11.");
    }

    public static boolean isSupportedJava() {
        String javaVersion = MaltegoHelper.getJavaVersion();
        return !MaltegoHelper.isPreJava8(javaVersion);
    }

    public static String getPropertyNonNull(String name) {
        String value = System.getProperty(name);
        return value == null ? "" : value;
    }
}

