/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.repository;

import com.paterva.maltego.util.repository.Repository;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class ObservableRepository<T>
implements Repository<T> {
    private final List<RepositoryListener<T>> listeners = Collections.synchronizedList(new LinkedList());

    @Override
    public void addRepositoryListener(RepositoryListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRepositoryListener(RepositoryListener<T> listener) {
        this.listeners.remove(listener);
    }

    protected void fireItemAdded(T item) {
        RepositoryEvent event = this.createEvent(item);
        this.getListeners().forEach(listener -> listener.onItemAdded(event));
    }

    protected void fireItemRemoved(T item) {
        RepositoryEvent event = this.createEvent(item);
        this.getListeners().forEach(listener -> listener.onItemRemoved(event));
    }

    protected void fireItemChanged(T item) {
        RepositoryEvent event = this.createEvent(item);
        this.getListeners().forEach(listener -> listener.onItemChanged(event));
    }

    private RepositoryEvent<T> createEvent(T item) {
        return new RepositoryEvent<T>(this, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RepositoryListener<T>> getListeners() {
        ArrayList<RepositoryListener<T>> listenersCopy;
        List<RepositoryListener<T>> list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<RepositoryListener<T>>(this.listeners);
        }
        return listenersCopy;
    }
}

