/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.yfiles;

import com.paterva.maltego.util.yfiles.IOHandlerJai;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import yguard.A.J.;
import yguard.A.J.IC;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.VA;
import yguard.A.J.yB;

public abstract class ImageOutputHandlerJai
extends IOHandlerJai {
    private boolean antiAliasMode;
    private boolean selectionPaintingEnabled;
    private final double margin = 10.0;

    protected ImageOutputHandlerJai() {
        this(false);
    }

    protected ImageOutputHandlerJai(boolean antiAlias) {
        this.antiAliasMode = antiAlias;
        this.selectionPaintingEnabled = true;
    }

    public boolean isSelectionPaintingEnabled() {
        return this.selectionPaintingEnabled;
    }

    public void setSelectionPaintingEnabled(boolean enabled) {
        this.selectionPaintingEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getTileBufferedImage(SA graph2D) throws IOException {
        BufferedImage bi = null;
        U graph2DView1 = (U)graph2D.\u00f1();
        U graph2DView2 = graph2DView1;
        if (graph2DView2 == null) {
            graph2DView2 = this.createDefaultGraph2DView(graph2D);
        }
        try {
            bi = this.getTileBufferedImage(graph2DView2);
        }
        finally {
            if (graph2DView1 == null) {
                graph2D.C((.B)graph2DView2);
            }
        }
        return bi;
    }

    public BufferedImage getTileBufferedImage(U graph2DView) throws IOException {
        IC graphicsContext;
        BufferedImage bi;
        Dimension dim = graph2DView.getCanvasSize();
        long sumPixels = dim.width * dim.height;
        if (sumPixels > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Image size of " + dim.width + "x" + dim.height + "=" + sumPixels + "px exceeds maximum size of " + Integer.MAX_VALUE + "px.");
        }
        try {
            bi = this.createImage(dim.width, dim.height);
        }
        catch (OutOfMemoryError outOfMemoryError1) {
            int i = (int)Math.ceil((double)(dim.width * dim.height) / 1048576.0);
            throw new OutOfMemoryError("Not enough memory for temporary image of size " + dim.width + 'x' + dim.height + " (" + i + "MPixels).  Approximately " + i * 4 + "MByte required.");
        }
        Graphics2D graphics2D = bi.createGraphics();
        if (!this.isSelectionPaintingEnabled()) {
            graphics2D.setRenderingHint(yB.N, yB.G);
        }
        if (this.antiAliasMode) {
            VA.B((Graphics2D)graphics2D);
        }
        if ((graphicsContext = this.createGraphicsContext(graph2DView, graphics2D)) != null) {
            graphics2D.setRenderingHint(yB.Y, graphicsContext);
        }
        graph2DView.paintVisibleContent(graphics2D);
        if (this.antiAliasMode) {
            VA.A((Graphics2D)graphics2D);
        }
        graphics2D.dispose();
        this.checkImageWriterIsPresent();
        return bi;
    }

    protected IC createGraphicsContext(U graph2DView, Graphics2D graphics2D) {
        IC graphicsContext = new IC();
        graphicsContext.A(true);
        graphicsContext.A(graph2DView);
        graphicsContext.A(graphics2D.getTransform());
        return graphicsContext;
    }

    protected abstract BufferedImage createImage(int var1, int var2);

    public U createDefaultGraph2DView(SA graph2D) {
        U graph2DView = new U(graph2D);
        Rectangle rect = graph2D.\u00d0();
        Dimension dim = new Dimension(rect.width, rect.height);
        graph2DView.setSize(dim);
        graph2DView.setPreferredSize(dim);
        graph2DView.zoomToArea((double)rect.x - this.margin, (double)rect.y - this.margin, (double)rect.width + 2.0 * this.margin, (double)rect.height + 2.0 * this.margin);
        graph2DView.setPaintDetailThreshold(0.0);
        return graph2DView;
    }

    protected abstract void checkImageWriterIsPresent() throws IOException;
}

