/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.graph.table.io.exp.TabularGraphExportResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openide.util.NbBundle;

class TabularExportSuccessPanel
extends JPanel {
    private JTextArea _overviewTextArea;
    private ButtonGroup buttonGroup1;

    public TabularExportSuccessPanel() {
        this.initComponents();
    }

    public void setResult(TabularGraphExportResult result) {
        this._overviewTextArea.setText(this.toString(result));
    }

    public String toString(TabularGraphExportResult result) {
        StringBuilder statsText = new StringBuilder();
        statsText.append("Exported items:\n");
        statsText.append(String.format("%6d", result.getEntitiesExported()));
        statsText.append(" Entities exported\n");
        statsText.append(String.format("%6d", result.getLinksExported()));
        statsText.append(" Links exported\n");
        if (result.getDuplicatesRemoved() > 0) {
            statsText.append(String.format("%6d", result.getDuplicatesRemoved()));
            statsText.append(" Duplicate rows discarded\n");
        }
        statsText.append(String.format("%6d", result.getLinesGenerated()));
        statsText.append(" Rows written\n");
        return statsText.toString();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this._overviewTextArea = new JTextArea();
        this.setLayout(new BorderLayout(5, 5));
        jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel1.setLayout(new BorderLayout(10, 10));
        jLabel1.setFont(new JLabel().getFont().deriveFont(1, (float)new JLabel().getFont().getSize() + 1.0f));
        jLabel1.setText(NbBundle.getMessage(TabularExportSuccessPanel.class, (String)"TabularExportSuccessPanel.jLabel1.text"));
        jPanel1.add((Component)jLabel1, "North");
        jScrollPane1.setBackground(new JPanel().getBackground());
        jScrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), NbBundle.getMessage(TabularExportSuccessPanel.class, (String)"TabularExportSuccessPanel.jScrollPane1.border.title")));
        jScrollPane1.setPreferredSize(new Dimension(215, 170));
        this._overviewTextArea.setEditable(false);
        this._overviewTextArea.setBackground(this.getBackground());
        this._overviewTextArea.setColumns(20);
        this._overviewTextArea.setLineWrap(true);
        this._overviewTextArea.setRows(7);
        this._overviewTextArea.setText(NbBundle.getMessage(TabularExportSuccessPanel.class, (String)"TabularExportSuccessPanel._overviewTextArea.text"));
        this._overviewTextArea.setWrapStyleWord(true);
        this._overviewTextArea.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jScrollPane1.setViewportView(this._overviewTextArea);
        jPanel1.add((Component)jScrollPane1, "Center");
        this.add((Component)jPanel1, "Center");
    }
}

