/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.table;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.ui.table.ConnectivityTableModel;
import com.paterva.maltego.graph.table.ui.table.HeaderColumnRenderer;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeaderRendererRotated;
import com.paterva.maltego.util.ui.RotatedLabel;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.editors.CenteredCheckBoxEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ConnectivityTablePanel
extends JPanel {
    private final CenteredCheckBoxEditor checkBoxEditor;
    private ConnectivityTableModel connectivityTableModel;
    private CheckBoxCellEditorListener editorListener;
    private JPanel connectivityPanel;
    private JScrollPane connectivityScrollPane;
    private JTable connectivityTable;
    public JPanel fromEntityPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JTextArea txHint;

    public ConnectivityTablePanel() {
        this.initComponents();
        ((RotatedLabel)this.fromEntityPanel).setDirection(RotatedLabel.Direction.VERTICAL_UP);
        ((RotatedLabel)this.fromEntityPanel).setForeground(UIManager.getLookAndFeelDefaults().getColor("connectivity-table-rotated-fg"));
        this.fromEntityPanel.setFont(this.fromEntityPanel.getFont().deriveFont(1, this.fromEntityPanel.getFont().getSize() + 3));
        this.checkBoxEditor = new CenteredCheckBoxEditor();
        this.connectivityTable.setDefaultEditor(Object.class, (TableCellEditor)this.checkBoxEditor);
        SampleHeaderRendererRotated sampleHeaderRotatedRenderer = new SampleHeaderRendererRotated();
        sampleHeaderRotatedRenderer.setDirection(SampleHeaderRendererRotated.LabelDirection.VERTICAL_UP);
        this.connectivityTable.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)sampleHeaderRotatedRenderer));
        this.addComponentListener(new PanelResizeListener());
    }

    public void setTabularGraph(TabularGraph tg, JTabbedPane mcTabbedPane) {
        this.connectivityTableModel = new ConnectivityTableModel(this.connectivityTable, tg);
        this.connectivityTable.setModel(this.connectivityTableModel);
        this.connectivityTable.setDefaultRenderer(Object.class, new HeaderColumnRenderer(this.connectivityTable, this.connectivityTableModel));
        this.updateTableLayout();
        if (this.editorListener != null) {
            this.checkBoxEditor.removeCellEditorListener((CellEditorListener)this.editorListener);
        }
        this.editorListener = new CheckBoxCellEditorListener(tg, mcTabbedPane);
        this.checkBoxEditor.addCellEditorListener((CellEditorListener)this.editorListener);
    }

    public void commitFinalEdit() {
        this.checkBoxEditor.stopCellEditing();
    }

    public List<DefaultTabularGraphLink> getRemovedLinks() {
        return this.connectivityTableModel.getRemovedLinks();
    }

    public List<DefaultTabularGraphLink> getAddedLinks() {
        return this.connectivityTableModel.getAddedLinks();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.txHint = new JTextArea();
        this.connectivityPanel = new JPanel();
        this.connectivityScrollPane = new JScrollPane();
        this.connectivityTable = new JTable();
        this.jPanel4 = new JPanel();
        this.fromEntityPanel = new RotatedLabel("From Entity");
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ConnectivityTablePanel.class, (String)"ConnectivityTablePanel.jLabel1.text"));
        this.jLabel1.setMinimumSize(new Dimension(30, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(1, this.jLabel2.getFont().getSize() + 3));
        this.jLabel2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ConnectivityTablePanel.class, (String)"ConnectivityTablePanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 10);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(ConnectivityTablePanel.class, (String)"ConnectivityTablePanel.jPanel1.border.title")));
        this.jPanel1.setLayout(new BorderLayout());
        this.txHint.setEditable(false);
        this.txHint.setLineWrap(true);
        this.txHint.setText(NbBundle.getMessage(ConnectivityTablePanel.class, (String)"ConnectivityTablePanel.txHint.text"));
        this.txHint.setWrapStyleWord(true);
        this.txHint.setOpaque(false);
        this.jPanel1.add((Component)this.txHint, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.connectivityScrollPane.setPreferredSize(new Dimension(453, 402));
        this.connectivityTable.setAutoCreateColumnsFromModel(false);
        this.connectivityTable.setAutoResizeMode(0);
        this.connectivityTable.setRowSelectionAllowed(false);
        this.connectivityTable.getTableHeader().setResizingAllowed(false);
        this.connectivityTable.getTableHeader().setReorderingAllowed(false);
        this.connectivityScrollPane.setViewportView(this.connectivityTable);
        GroupLayout connectivityPanelLayout = new GroupLayout(this.connectivityPanel);
        this.connectivityPanel.setLayout(connectivityPanelLayout);
        connectivityPanelLayout.setHorizontalGroup(connectivityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectivityScrollPane, -1, 423, Short.MAX_VALUE));
        connectivityPanelLayout.setVerticalGroup(connectivityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectivityScrollPane, -1, 239, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 10);
        this.add((Component)this.connectivityPanel, gridBagConstraints);
        GroupLayout fromEntityPanelLayout = new GroupLayout(this.fromEntityPanel);
        this.fromEntityPanel.setLayout(fromEntityPanelLayout);
        fromEntityPanelLayout.setHorizontalGroup(fromEntityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 29, Short.MAX_VALUE));
        fromEntityPanelLayout.setVerticalGroup(fromEntityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 189, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.fromEntityPanel, -1, -1, Short.MAX_VALUE).addGap(1, 1, 1)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap(31, Short.MAX_VALUE).addComponent(this.fromEntityPanel, -2, -1, -2).addContainerGap(31, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private synchronized void updateTableLayout() {
        int tableWidth = this.getTableWidth();
        if (this.connectivityScrollPane.getVerticalScrollBar().isVisible()) {
            tableWidth += this.connectivityScrollPane.getVerticalScrollBar().getWidth();
        }
        GroupLayout layout = (GroupLayout)this.connectivityPanel.getLayout();
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectivityScrollPane, -1, tableWidth, tableWidth));
    }

    private int getTableWidth() {
        int width = 160;
        TableColumnModel model = this.connectivityTable.getColumnModel();
        for (int i = 1; i < model.getColumnCount(); ++i) {
            width += this.connectivityTableModel.getRowHeight();
        }
        return width;
    }

    private class CheckBoxCellEditorListener
    implements CellEditorListener {
        final TabularGraph tg;
        final JTabbedPane mcTabbedPane;

        public CheckBoxCellEditorListener(TabularGraph tg, JTabbedPane mcTabbedPane) {
            this.tg = tg;
            this.mcTabbedPane = mcTabbedPane;
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this.mcTabbedPane.setEnabledAt(3, this.shouldActivateTab());
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }

        private boolean shouldActivateTab() {
            List testList = this.tg.getLinks();
            List<DefaultTabularGraphLink> addedLinks = ConnectivityTablePanel.this.connectivityTableModel.getAddedLinks();
            if (testList.isEmpty() && !addedLinks.isEmpty()) {
                return true;
            }
            List<DefaultTabularGraphLink> removedLinks = ConnectivityTablePanel.this.connectivityTableModel.getRemovedLinks();
            return testList.size() + addedLinks.size() - removedLinks.size() != 0;
        }
    }

    private class PanelResizeListener
    implements ComponentListener {
        private boolean verticalVisible;
        private boolean horizontalVisible;

        public PanelResizeListener() {
            this.verticalVisible = ConnectivityTablePanel.this.connectivityScrollPane.getVerticalScrollBar().isVisible();
            this.horizontalVisible = ConnectivityTablePanel.this.connectivityScrollPane.getHorizontalScrollBar().isVisible();
        }

        @Override
        public synchronized void componentResized(ComponentEvent e) {
            boolean vertiVisible = ConnectivityTablePanel.this.connectivityScrollPane.getVerticalScrollBar().isVisible();
            boolean horiVisible = ConnectivityTablePanel.this.connectivityScrollPane.getHorizontalScrollBar().isVisible();
            if (this.verticalVisible != vertiVisible || this.horizontalVisible != this.horizontalVisible) {
                this.verticalVisible = vertiVisible;
                this.horizontalVisible = horiVisible;
                ConnectivityTablePanel.this.updateTableLayout();
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

