/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.table;

import com.paterva.maltego.graph.table.ui.table.ConnectivityTableModel;
import com.paterva.maltego.graph.table.ui.wizard.IndexPainter;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeader;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public final class HeaderColumnRenderer
extends DefaultTableCellRenderer {
    private final JTableHeader header;
    private final TableCellRenderer headerRenderer;
    private final ConnectivityTableModel model;
    private int _entityNum;

    public HeaderColumnRenderer(JTable table, ConnectivityTableModel model) {
        this.header = table.getTableHeader();
        this.headerRenderer = this.header.getDefaultRenderer();
        this.model = model;
        this._entityNum = -1;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row == column - 1) {
            return this.headerRenderer.getTableCellRendererComponent(table, null, false, false, row, column);
        }
        if (value instanceof Boolean) {
            return this.model.getLinkBox(row, column);
        }
        if (value instanceof SampleHeader) {
            SampleHeader sampleHeader = (SampleHeader)((Object)value);
            this.setForeground(this.header.getForeground());
            this.setBackground(this.header.getBackground());
            this.setFont(this.header.getFont());
            this.setIcon(sampleHeader.icon);
            this.setText(sampleHeader.text);
            this._entityNum = sampleHeader.entityNum;
        } else {
            this._entityNum = -1;
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._entityNum > 0) {
            IndexPainter.paint(g, this._entityNum, this.getFont(), 5, 30);
        }
    }
}

