/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.ui.wizard.EntityMappingPanel;
import com.paterva.maltego.graph.table.ui.wizard.MappingPanel;
import com.paterva.maltego.matching.TypeToPropertiesMapMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.Exceptions;

public class EntityMappingController
extends ValidatingController<MappingPanel>
implements WizardDescriptor.ValidatingPanel {
    public EntityMappingController() {
        this.setName("Map Columns to Entities");
    }

    protected MappingPanel createComponent() {
        return new EntityMappingPanel();
    }

    protected void readSettings(WizardDescriptor settings) {
        try {
            TabularGraph tabularGraph = (TabularGraph)settings.getProperty("graphTable");
            boolean newGraph = "New mapping".equals(tabularGraph.getName());
            List files = (List)this.getDescriptor().getProperty("files");
            MappingPanel comp = (MappingPanel)this.component();
            comp.setTabularGraphAndSampleFile(tabularGraph, (File)files.get(0));
            if (comp instanceof EntityMappingPanel) {
                EntityMappingPanel mapingPanel = (EntityMappingPanel)comp;
                if (newGraph) {
                    boolean hasBeenAutoDetected = (Boolean)settings.getProperty("hasEntitiesbeenAutoDetected");
                    if (!hasBeenAutoDetected) {
                        mapingPanel.attemptToPreMapEntities();
                        settings.putProperty("hasEntitiesbeenAutoDetected", (Object)true);
                    }
                } else {
                    mapingPanel.updateHtoComboBox();
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        MatchingRuleDescriptor entityRule = this.toMatchingRule(this.getAllSpecNames(tabularGraph), tabularGraph.getTypeStrictProperties());
        settings.putProperty("entityMatchingRule", (Object)entityRule);
    }

    private Set<String> getAllSpecNames(TabularGraph tabularGraph) {
        HashSet<String> specNames = new HashSet<String>();
        for (TabularGraphEntity entity : tabularGraph.getEntities()) {
            specNames.add(entity.getEntitySpecName());
        }
        return specNames;
    }

    private MatchingRuleDescriptor toMatchingRule(Set<String> specNames, Map<String, Set<String>> typeStrictProperties) {
        TypeToPropertiesMapMatchingRuleDescriptor entityRule = new TypeToPropertiesMapMatchingRuleDescriptor();
        for (String specName : specNames) {
            Set<String> strictProperties = typeStrictProperties.get(specName);
            boolean matchValue = strictProperties == null;
            entityRule.update(specName, strictProperties, matchValue);
        }
        return entityRule;
    }

    public void validate() throws WizardValidationException {
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        List entities = tabularGraph.getEntities();
        String error = entities == null || entities.isEmpty() ? "No columns have been mapped." : this.checkAllPropertiesMapped(tabularGraph);
        if (error != null) {
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
    }

    private String checkAllPropertiesMapped(TabularGraph tabularGraph) {
        List entities = tabularGraph.getEntities();
        int entityNum = 0;
        for (TabularGraphEntity entity : entities) {
            ++entityNum;
            for (int column : entity.getColumns()) {
                PropertyDescriptor pd = entity.getProperty(column);
                if (pd != null) continue;
                String columnName = tabularGraph.getColumnNames()[column];
                ((MappingPanel)this.component()).select(entity.getColumns());
                return this.getUnmappedPropertyError(entity, entityNum, columnName);
            }
        }
        return null;
    }

    private String getUnmappedPropertyError(TabularGraphEntity entity, int entityNum, String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(entity.getEntitySpecName());
        sb.append("(");
        sb.append(entityNum);
        sb.append(")->");
        sb.append(columnName);
        sb.append(" is not mapped to a property. All columns added to an entity must be mapped.");
        return sb.toString();
    }
}

