/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.save;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.CloudGraphRegistry;
import com.maltego.cloud.data.CloudGraphContentMetadata;
import com.maltego.cloud.lock.CloudGraphQueryResult;
import com.maltego.cloud.lock.CloudGraphQueryState;
import com.maltego.cloud.lock.CloudGraphQueryUtils;
import com.maltego.cloud.serializer.NeoJsonAttachments;
import com.maltego.cloud.serializer.NeoJsonAttachmentsFactory;
import com.maltego.cloud.serializer.NeoJsonWriter;
import com.maltego.cloud.ui.analytics.FinishSaveToCasesEvent;
import com.maltego.cloud.ui.analytics.OpenGraphInWebEvent;
import com.maltego.cloud.ui.analytics.StartSaveToCasesEvent;
import com.maltego.cloud.ui.save.CloudGraphSaveOperation;
import com.maltego.cloud.ui.save.SaveToCloudDialog;
import com.maltego.cloud.ui.save.SaveToCloudOptions;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class SaveToCloudAction
extends TopGraphAction {
    private static final Logger LOG = Logger.getLogger(SaveToCloudAction.class.getName());
    private final CloudAuth cloudAuth = CloudAuth.getDefault();
    private final CloudGraphRegistry cloudGraphRegistry = CloudGraphRegistry.getDefault();

    public SaveToCloudAction() {
        LicenseManager.A().A(ignored -> this.updateVisible());
        this.updateVisible();
    }

    private void updateVisible() {
        this.putValue("visible", this.cloudAuth.isCloudAuthEnabled());
    }

    public String getName() {
        return "Save To Maltego Cases";
    }

    protected String iconResource() {
        return "com/maltego/cloud/ui/save/SaveToCloud.png";
    }

    protected boolean isEnabled(TopComponent tc) {
        boolean enabled;
        boolean bl = enabled = super.isEnabled(tc) && this.cloudAuth.isCloudAuthEnabled() && this.cloudAuth.isAuthorized();
        if (enabled) {
            GraphID graphID = this.getTopGraphID();
            if (this.cloudGraphRegistry.isCloudGraph(graphID) && !this.cloudGraphRegistry.isEditable(graphID)) {
                enabled = false;
            } else if (this.cloudGraphRegistry.isVersionOfCloudGraph(graphID) && !this.cloudGraphRegistry.isVersionOfCloudGraphSupported(graphID)) {
                enabled = false;
            }
        }
        return enabled;
    }

    protected void actionPerformed(TopComponent tc) {
        if (this.cloudAuth.isCloudAuthEnabled()) {
            GraphID maltegoGraphID = this.getTopGraphID();
            try {
                this.save(maltegoGraphID, false);
            }
            catch (Exception ex) {
                this.displayErrorDialog("Cloud Graph could not be saved. ", maltegoGraphID, ex);
            }
        }
    }

    void save(GraphID maltegoGraphID, boolean saveInEDT) throws Exception {
        if (this.cloudAuth.isCloudAuthEnabled()) {
            if (maltegoGraphID == null) {
                return;
            }
            StartSaveToCasesEvent.send();
            CloudGraph cloudGraph = this.cloudGraphRegistry.getCloudGraph(maltegoGraphID);
            boolean openGraphInBrowser = false;
            if (cloudGraph == null) {
                TopComponent topComponent = this.getTopComponent();
                String graphName = GraphUtils.getTopGraphName((TopComponent)topComponent, (String)"Cloud Graph");
                CloudGraphContentMetadata metaData = this.cloudGraphRegistry.getContentMetadata(maltegoGraphID);
                cloudGraph = new CloudGraph(maltegoGraphID, graphName, Boolean.TRUE, metaData);
            } else if (!this.cloudGraphRegistry.isEditable(maltegoGraphID)) {
                throw new IllegalStateException("Graph is Read Only!");
            }
            if (cloudGraph.getCase() == null) {
                SaveToCloudOptions saveToCloudResult = SaveToCloudDialog.showSaveToCloudDialog(cloudGraph.getName());
                if (saveToCloudResult == null || saveToCloudResult.getGraphName() == null || saveToCloudResult.getGraphName().isEmpty() || saveToCloudResult.getSelectedCase() == null) {
                    return;
                }
                cloudGraph.setName(saveToCloudResult.getGraphName());
                cloudGraph.setCase(saveToCloudResult.getSelectedCase());
                openGraphInBrowser = saveToCloudResult.mustOpenGraphInBrowser();
            }
            this.saveToCloudInBackground(cloudGraph, openGraphInBrowser, saveInEDT);
        }
    }

    private void saveToCloudInBackground(CloudGraph cloudGraph, boolean openGraphInBrowser, boolean saveInEDT) throws JsonProcessingException {
        NeoJsonAttachmentsFactory attsFactory = new NeoJsonAttachmentsFactory();
        Map attachments = attsFactory.getAttachments(cloudGraph.getMaltegoGraphID());
        NeoJsonWriter jsonWriter = new NeoJsonWriter(cloudGraph.getMaltegoGraphID(), cloudGraph.getName(), attachments, cloudGraph.getContentMetadata());
        String graphJson = jsonWriter.writeToString();
        LOG.finer(graphJson);
        if (saveInEDT && SwingUtilities.isEventDispatchThread()) {
            this.saveToCloudInBackgroundStep(cloudGraph, graphJson, attachments, openGraphInBrowser, true);
        } else {
            new Thread(() -> this.saveToCloudInBackgroundStep(cloudGraph, graphJson, attachments, openGraphInBrowser, false), "Save To Cloud").start();
        }
    }

    private void saveToCloudInBackgroundStep(CloudGraph cloudGraph, String graphJson, Map<Guid, NeoJsonAttachments> attachments, boolean openGraphInBrowser, boolean saveInEDT) {
        try {
            GraphID maltegoGraphID = cloudGraph.getMaltegoGraphID();
            String graphName = cloudGraph.getName();
            if (!this.cloudAuth.isAuthorized()) {
                String problemMessage = this.cloudAuth.getProblemMessage(true);
                if (saveInEDT && SwingUtilities.isEventDispatchThread()) {
                    this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved - authentication token invalid: " + problemMessage, maltegoGraphID, null);
                } else {
                    SwingUtilities.invokeLater(() -> this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved - authentication token invalid: " + problemMessage, maltegoGraphID, null));
                }
                return;
            }
            this.saveToCloud(cloudGraph, graphJson, attachments);
            FinishSaveToCasesEvent.send(openGraphInBrowser);
            TopComponent topComponent = this.getTopComponent();
            GraphDataObject gdo = (GraphDataObject)topComponent.getLookup().lookup(GraphDataObject.class);
            gdo.setModified(false);
            gdo.rename(cloudGraph.getName());
            gdo.updateDisplayName();
            gdo.updateBackupData();
            if (openGraphInBrowser) {
                try {
                    OpenGraphInWebEvent.send();
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(CloudAuth.getDefault().getBrowserGraphUrlPrefix() + "/" + maltegoGraphID));
                }
                catch (MalformedURLException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
        catch (Exception ex) {
            GraphID maltegoGraphID = cloudGraph.getMaltegoGraphID();
            String graphName = cloudGraph.getName();
            if (saveInEDT && SwingUtilities.isEventDispatchThread()) {
                this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved. ", maltegoGraphID, ex);
            }
            SwingUtilities.invokeLater(() -> this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved. ", maltegoGraphID, ex));
        }
    }

    private void saveToCloud(CloudGraph cloudGraph, String graphJson, Map<Guid, NeoJsonAttachments> attachments) throws Exception {
        CloudGraphQueryResult result = CloudGraphQueryUtils.findGraph((CloudAuth)this.cloudAuth, (GraphID)cloudGraph.getMaltegoGraphID());
        CloudGraphQueryState state = result.getQueryState();
        switch (state) {
            case ERROR__GRAPH_DOES_NOT_EXIST_YET: {
                this.sendGraph(cloudGraph, graphJson, attachments, true);
                break;
            }
            case GRAPH_EXISTS_AND_USER_HAS_LOCK: {
                this.sendGraph(cloudGraph, graphJson, attachments, false);
                break;
            }
            case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: 
            case FIND__GRAPH_EXISTS_BUT_NOT_LOCKED: 
            case FAILED: {
                LOG.log(Level.WARNING, state.getMsg() + " Graph ID: {0}, with name: {1}", new Object[]{cloudGraph.getMaltegoGraphID(), cloudGraph.getName()});
                throw new IllegalStateException(state.getMsg());
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    private void sendGraph(CloudGraph cloudGraph, String graphJson, Map<Guid, NeoJsonAttachments> attachments, boolean isNewGraph) throws IOException, GeneralSecurityException {
        CloudGraphSaveOperation operation = CloudGraphSaveOperation.create(cloudGraph);
        operation.perform(graphJson, attachments, isNewGraph);
        GraphID graphID = cloudGraph.getMaltegoGraphID();
        String graphName = cloudGraph.getName();
        if (this.cloudGraphRegistry.isVersionOfCloudGraph(graphID)) {
            this.cloudGraphRegistry.removeVersionOfCloudGraph(graphID);
        }
        this.cloudGraphRegistry.addCloudGraph(graphID, cloudGraph);
        RecentCloudGraphs.getDefault().addCloudGraph(graphID.toString(), graphName);
    }

    private void displayErrorDialog(String errorPrefix, GraphID cloudGraphId, Exception ex) {
        String errorMessage = ex == null ? errorPrefix : errorPrefix + ex.getMessage();
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)errorMessage);
        msg.setMessageType(0);
        msg.setTitle(this.getName());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        LOG.log(Level.WARNING, "Graph {0}: {1}", new Object[]{cloudGraphId, errorMessage});
        if (ex != null) {
            NormalException.logStackTrace((Throwable)ex);
        }
    }
}

