/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.imgfactoryapi.IconValidation;
import com.paterva.maltego.util.Args;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class VirtualIcon {
    private final String category;
    private final String nameOrAlias;

    public VirtualIcon(String category, String nameOrAlias) {
        Args.notNull((Object)nameOrAlias, (String)"nameOrAlias");
        this.category = IconValidation.getCategoryError(category).isPresent() ? null : category;
        this.nameOrAlias = nameOrAlias;
    }

    public static Optional<VirtualIcon> parse(String iconString) {
        VirtualIcon icon = null;
        if (!StringUtils.isBlank((CharSequence)iconString)) {
            String[] tokens = iconString.trim().split("\\s*/\\s*");
            if (tokens.length == 1) {
                icon = new VirtualIcon(null, tokens[0]);
            } else if (tokens.length == 2) {
                icon = new VirtualIcon(tokens[0], tokens[1]);
            }
        }
        return Optional.ofNullable(icon);
    }

    public Optional<String> getCategory() {
        return Optional.ofNullable(this.category);
    }

    public String getNameOrAlias() {
        return this.nameOrAlias;
    }

    public String toString() {
        return this.getCategory().map(cat -> cat + '/' + this.nameOrAlias).orElse(this.nameOrAlias);
    }
}

