/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runregistry;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.RunProvider;
import com.paterva.maltego.runregistry.RunProviderComparator;
import com.paterva.maltego.runregistry.RunRegistry;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openide.util.Lookup;

class DefaulRunRegistry
extends RunRegistry {
    private final RunProvider[] _providers = Lookup.getDefault().lookupAll(RunProvider.class).toArray(new RunProvider[0]);

    public DefaulRunRegistry() {
        Arrays.sort(this._providers, new RunProviderComparator());
    }

    @Override
    public List<RunProviderItem> getItems(String component) {
        ArrayList<RunProviderItem> items = new ArrayList<RunProviderItem>();
        for (RunProvider provider : this._providers) {
            items.addAll(provider.getItems(component));
        }
        return items;
    }

    @Override
    public void run(List<RunProviderItem> items, GraphID graphID, Set<EntityID> entities) {
        for (RunProvider provider : this._providers) {
            provider.run(items, graphID, entities);
        }
    }

    @Override
    public boolean isUpdating() {
        for (RunProvider provider : this._providers) {
            if (!provider.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFilterText(String component, String text) {
        for (RunProvider provider : this._providers) {
            provider.setFilterText(component, text);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        for (RunProvider provider : this._providers) {
            provider.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        for (RunProvider provider : this._providers) {
            provider.removePropertyChangeListener(listener);
        }
    }

    @Override
    public int getPosition() {
        return 0;
    }
}

