/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.transforms;

import com.paterva.maltego.importexport.BasicArrayConfig;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.manager.imex.transforms.TransformConfigNode;
import com.paterva.maltego.transform.manager.imex.transforms.TransformExistInfo;
import java.util.List;
import org.openide.nodes.Node;

public class TransformConfig
extends BasicArrayConfig<TransformDescriptor> {
    private TransformServerInfo[] _servers;

    public TransformConfig(TransformServerInfo[] servers, TransformDescriptor[] transforms) {
        this(servers, transforms, transforms);
    }

    public TransformConfig(TransformServerInfo[] servers, TransformDescriptor[] transforms, TransformDescriptor[] selected) {
        this.setAll(transforms);
        this.setSelected(selected);
        this._servers = servers;
    }

    public TransformServerInfo[] getServers() {
        return this._servers;
    }

    public int getPriority() {
        return 30;
    }

    public boolean hasSelectedTransforms(TransformServerInfo server) {
        for (String transformName : server.getTransforms()) {
            for (TransformDescriptor transform : (TransformDescriptor[])this.getSelected()) {
                if (!transform.getName().equals(transformName)) continue;
                return true;
            }
        }
        return false;
    }

    public TransformDescriptor getTransform(String name) {
        for (TransformDescriptor transform : (TransformDescriptor[])this.getAll()) {
            if (!transform.getName().equals(name)) continue;
            return transform;
        }
        return null;
    }

    public Node getConfigNode(boolean showExistInfo) {
        TransformExistInfo existInfo = showExistInfo ? new TransformExistInfo() : null;
        return new TransformConfigNode(this, existInfo);
    }

    protected TransformDescriptor nodeToType(Node node) {
        return (TransformDescriptor)node.getLookup().lookup(TransformDescriptor.class);
    }

    protected TransformDescriptor[] listToArray(List<TransformDescriptor> list) {
        return list.toArray(new TransformDescriptor[list.size()]);
    }
}

