/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.cache.skeletons;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.cache.CachedItems;
import com.paterva.maltego.graph.cache.skeletons.LinkSkeletonCache;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.LinkDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class LinkSkeletonProvider {
    private final GraphID _graphID;
    private final GraphDataStoreReader _reader;
    private final LinkSkeletonCache _cache;
    private final GraphDataStore _graphDataStore;
    private LinkDataQuery _skeletonQuery;
    private PropertyChangeListener _dataStoreListener;

    public LinkSkeletonProvider(GraphID graphID) throws GraphStoreException {
        this._graphID = graphID;
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
        this._graphDataStore = graphStore.getGraphDataStore();
        this._reader = this._graphDataStore.getDataStoreReader();
        this._cache = new LinkSkeletonCache();
        this._dataStoreListener = new DataStoreListener();
        this._graphDataStore.addPropertyChangeListener(this._dataStoreListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new GraphCloseListener());
    }

    public Map<LinkID, MaltegoLink> getLinkSkeletons(Collection<LinkID> ids) throws GraphStoreException {
        CachedItems items = this._cache.get(ids);
        Set<LinkID> missedKeys = items.getMissedKeys();
        Map<LinkID, MaltegoLink> linkSkeletons = items.getItems();
        if (!missedKeys.isEmpty()) {
            LinkDataQuery query = this.getLinkSkeletonQuery();
            LinksDataQuery linksQuery = new LinksDataQuery();
            linksQuery.setIDs(missedKeys);
            linksQuery.setPartDataQuery((PartDataQuery)query);
            Map links = this._reader.getLinks(linksQuery);
            this._cache.put(links.values());
            linkSkeletons.putAll(links);
        }
        return linkSkeletons;
    }

    public MaltegoLink getLinkSkeleton(LinkID id) throws GraphStoreException {
        MaltegoLink skeleton = (MaltegoLink)this._cache.get(id);
        if (skeleton == null) {
            LinkDataQuery query = this.getLinkSkeletonQuery();
            skeleton = this._reader.getLink(id, query);
            this._cache.put(id, skeleton);
        }
        return skeleton;
    }

    public void putSkeleton(MaltegoLink link) {
        MaltegoLink skeleton = link.createClone();
        this._cache.put(skeleton.getID(), skeleton);
    }

    private synchronized LinkDataQuery getLinkSkeletonQuery() {
        if (this._skeletonQuery == null) {
            this._skeletonQuery = new LinkDataQuery();
            this._skeletonQuery.setAllSections(true);
            this._skeletonQuery.setAllProperties(true);
        }
        return this._skeletonQuery;
    }

    private class GraphCloseListener
    implements PropertyChangeListener {
        private GraphCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("graphClosed".equals(evt.getPropertyName()) && evt.getNewValue().equals(LinkSkeletonProvider.this._graphID)) {
                GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                LinkSkeletonProvider.this._graphDataStore.removePropertyChangeListener(LinkSkeletonProvider.this._dataStoreListener);
                LinkSkeletonProvider.this._dataStoreListener = null;
            }
        }
    }

    private class DataStoreListener
    implements PropertyChangeListener {
        private DataStoreListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("partsChanged".equals(evt.getPropertyName())) {
                GraphDataMods mods = (GraphDataMods)evt.getNewValue();
                LinkSkeletonProvider.this._cache.remove(mods.getLinksUpdated().keySet());
            }
        }
    }
}

