/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import java.util.Iterator;
import java.util.LinkedList;

public final class SharedMemorySync {
    private SharedMemorySync() {
    }

    @CompilerDirectives.TruffleBoundary
    public static int doVolatileGet(DynamicObject target, int intArrayOffset) {
        MemoryFence.acquire();
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedIntArray typedArray = (TypedArray.TypedIntArray)array;
        return typedArray.getInt(target, intArrayOffset, InteropLibrary.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt doVolatileGetBigInt(DynamicObject target, int intArrayOffset) {
        MemoryFence.acquire();
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedBigIntArray typedArray = (TypedArray.TypedBigIntArray)array;
        return typedArray.getBigInt(target, intArrayOffset, InteropLibrary.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    public static void doVolatilePut(DynamicObject target, int index, int value) {
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedIntArray typedArray = (TypedArray.TypedIntArray)array;
        typedArray.setInt(target, index, value, InteropLibrary.getUncached());
        MemoryFence.release();
    }

    @CompilerDirectives.TruffleBoundary
    public static void doVolatilePutBigInt(DynamicObject target, int index, BigInt value) {
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedBigIntArray typedArray = (TypedArray.TypedBigIntArray)array;
        typedArray.setBigInt(target, index, value, InteropLibrary.getUncached());
        MemoryFence.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static boolean compareAndSwapInt(JSAgent agent, DynamicObject target, int intArrayOffset, int initial, int result) {
        agent.atomicSectionEnter(target);
        try {
            int value = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            if (value == initial) {
                SharedMemorySync.doVolatilePut(target, intArrayOffset, result);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            agent.atomicSectionLeave(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static boolean compareAndSwapBigInt(JSAgent agent, DynamicObject target, int intArrayOffset, BigInt initial, BigInt result) {
        agent.atomicSectionEnter(target);
        try {
            BigInt value = SharedMemorySync.doVolatileGetBigInt(target, intArrayOffset);
            if (value.compareTo(initial) == 0) {
                SharedMemorySync.doVolatilePutBigInt(target, intArrayOffset, result);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            agent.atomicSectionLeave(target);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static long atomicFetchOrGetUnsigned(JSAgent agent, DynamicObject target, int intArrayOffset, Object expected, Object replacement) {
        agent.atomicSectionEnter(target);
        long read = JSRuntime.toUInt32(SharedMemorySync.doVolatileGet(target, intArrayOffset));
        if (read == JSRuntime.toUInt32(expected)) {
            SharedMemorySync.doVolatilePut(target, intArrayOffset, (int)JSRuntime.toUInt32(replacement));
        }
        agent.atomicSectionLeave(target);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static long atomicFetchOrGetLong(JSAgent agent, DynamicObject target, int intArrayOffset, long expected, long replacement) {
        agent.atomicSectionEnter(target);
        try {
            int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            if ((long)read == expected) {
                SharedMemorySync.doVolatilePut(target, intArrayOffset, (int)replacement);
            }
            long l = read;
            return l;
        }
        finally {
            agent.atomicSectionLeave(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static int atomicFetchOrGetInt(JSAgent agent, DynamicObject target, int intArrayOffset, int expected, int replacement) {
        agent.atomicSectionEnter(target);
        try {
            int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            if (read == expected) {
                SharedMemorySync.doVolatilePut(target, intArrayOffset, replacement);
            }
            int n = read;
            return n;
        }
        finally {
            agent.atomicSectionLeave(target);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int atomicFetchOrGetShort(JSAgent agent, DynamicObject target, int intArrayOffset, int expected, int replacement, boolean sign) {
        short expectedChopped;
        agent.atomicSectionEnter(target);
        int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
        read = sign ? read : read & 0xFFFF;
        short s = expectedChopped = sign ? (short)expected : (short)(expected & 0xFFFF);
        if (read == expectedChopped) {
            int signed = sign ? replacement : replacement & 0xFFFF;
            SharedMemorySync.doVolatilePut(target, intArrayOffset, (short)signed);
        }
        agent.atomicSectionLeave(target);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static int atomicFetchOrGetByte(JSAgent agent, DynamicObject target, int intArrayOffset, int expected, int replacement, boolean sign) {
        agent.atomicSectionEnter(target);
        try {
            byte expectedChopped;
            int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            read = sign ? read : read & 0xFF;
            byte by = expectedChopped = sign ? (byte)expected : (byte)(expected & 0xFF);
            if (read == expectedChopped) {
                int signed = sign ? replacement : replacement & 0xFF;
                SharedMemorySync.doVolatilePut(target, intArrayOffset, (byte)signed);
            }
            int n = read;
            return n;
        }
        finally {
            agent.atomicSectionLeave(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static BigInt atomicFetchOrGetBigInt(JSAgent agent, DynamicObject target, int intArrayOffset, BigInt expected, BigInt replacement) {
        agent.atomicSectionEnter(target);
        try {
            BigInt read = SharedMemorySync.doVolatileGetBigInt(target, intArrayOffset);
            if (read.compareTo(expected) == 0) {
                SharedMemorySync.doVolatilePutBigInt(target, intArrayOffset, replacement);
            }
            BigInt bigInt = read;
            return bigInt;
        }
        finally {
            agent.atomicSectionLeave(target);
        }
    }

    public static JSAgentWaiterList.JSAgentWaiterListEntry getWaiterList(JSContext context, JSAgent agent, DynamicObject target, int indexPos) {
        DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer(target);
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(arrayBuffer);
        int offset = JSArrayBufferView.getByteOffset(target, context);
        int bytesPerElement = JSArrayBufferView.typedArrayGetArrayType(target).bytesPerElement();
        return waiterList.getListForIndex(indexPos * bytesPerElement + offset);
    }

    @CompilerDirectives.TruffleBoundary
    public static void enterCriticalSection(JSAgent agent, JSAgentWaiterList.JSAgentWaiterListEntry wl) {
        assert (!agent.inCriticalSection());
        agent.criticalSectionEnter(wl);
    }

    @CompilerDirectives.TruffleBoundary
    public static void leaveCriticalSection(JSAgent agent, JSAgentWaiterList.JSAgentWaiterListEntry wl) {
        agent.criticalSectionLeave(wl);
    }

    public static boolean agentCanSuspend(JSAgent agent) {
        return agent.canBlock();
    }

    @CompilerDirectives.TruffleBoundary
    public static void addWaiter(JSAgent agent, JSAgentWaiterList.JSAgentWaiterListEntry wl, JSAgentWaiterList.WaiterRecord waiterRecord, boolean isAsync) {
        assert (agent.inCriticalSection());
        assert (!wl.contains(waiterRecord));
        wl.add(waiterRecord);
        if (isAsync && Double.isFinite(waiterRecord.getTimeout())) {
            waiterRecord.setCreationTime(System.nanoTime() / 1000000L);
            agent.enqueueWaitAsyncPromiseJob(waiterRecord);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void removeWaiter(JSAgent agent, JSAgentWaiterList.JSAgentWaiterListEntry wl, JSAgentWaiterList.WaiterRecord w) {
        assert (agent.inCriticalSection());
        assert (wl.contains(w));
        wl.remove(w);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean suspendAgent(JSAgent agent, JSAgentWaiterList.JSAgentWaiterListEntry wl, JSAgentWaiterList.WaiterRecord waiterRecord) {
        assert (agent.inCriticalSection());
        assert (agent.getSignifier() == waiterRecord.getAgentSignifier());
        assert (wl.contains(waiterRecord));
        assert (agent.canBlock());
        agent.criticalSectionLeave(wl);
        boolean interrupt = false;
        try {
            Thread.sleep((long)waiterRecord.getTimeout());
        }
        catch (InterruptedException e) {
            interrupt = true;
        }
        agent.criticalSectionEnter(wl);
        return interrupt;
    }

    @CompilerDirectives.TruffleBoundary
    public static void notifyWaiter(JSAgent agent, JSAgentWaiterList.WaiterRecord waiterRecord) {
        assert (agent.inCriticalSection());
        assert (waiterRecord.getPromiseCapability() == null);
        agent.wakeAgent(waiterRecord.getAgentSignifier());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSAgentWaiterList.WaiterRecord[] removeWaiters(JSAgent agent, JSAgentWaiterList.JSAgentWaiterListEntry wl, int count) {
        assert (agent.inCriticalSection());
        int c = 0;
        Iterator iter = wl.iterator();
        LinkedList<JSAgentWaiterList.WaiterRecord> list = new LinkedList<JSAgentWaiterList.WaiterRecord>();
        while (iter.hasNext() && c < count) {
            JSAgentWaiterList.WaiterRecord wr = (JSAgentWaiterList.WaiterRecord)iter.next();
            if (wr.getPromiseCapability() != null && wr.isReadyToResolve()) continue;
            list.add(wr);
            iter.remove();
            ++c;
        }
        return list.toArray(new JSAgentWaiterList.WaiterRecord[c]);
    }
}

