/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseOrConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseOrNodeGen;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

@NodeInfo(shortName="|")
public abstract class JSBitwiseOrNode
extends JSBinaryNode {
    protected JSBitwiseOrNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
            if (rightValue == 0) {
                return JSToInt32Node.create(left, true);
            }
            return JSBitwiseOrConstantNode.create(left, rightValue);
        }
        Truncatable.truncate(right);
        return JSBitwiseOrNodeGen.create(left, right);
    }

    public abstract Object executeObject(Object var1, Object var2);

    @Specialization
    protected int doInteger(int a, int b) {
        return a | b;
    }

    @Specialization
    protected int doSafeIntegerInt(SafeInteger a, int b) {
        return this.doInteger(a.intValue(), b);
    }

    @Specialization
    protected int doIntSafeInteger(int a, SafeInteger b) {
        return this.doInteger(a, b.intValue());
    }

    @Specialization
    protected int doSafeInteger(SafeInteger a, SafeInteger b) {
        return this.doInteger(a.intValue(), b.intValue());
    }

    @Specialization
    protected int doDouble(double a, double b, @Cached(value="create()") JSToInt32Node leftInt32, @Cached(value="create()") JSToInt32Node rightInt32) {
        return this.doInteger(leftInt32.executeInt(a), rightInt32.executeInt(b));
    }

    @Specialization
    protected BigInt doBigInt(BigInt a, BigInt b) {
        return a.or(b);
    }

    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a, Object b, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, b);
    }

    protected String getOverloadedOperatorName() {
        return "|";
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doInteger", "doIntSafeInteger", "doSafeIntegerInt", "doSafeInteger", "doDouble", "doBigInt"})
    protected Object doGeneric(Object a, Object b, @Cached(value="create()") JSToNumericNode leftNumeric, @Cached(value="create()") JSToNumericNode rightNumeric, @Cached(value="createInner()") JSBitwiseOrNode or, @Cached(value="create()") BranchProfile mixedNumericTypes) {
        Object left = leftNumeric.execute(a);
        Object right = rightNumeric.execute(b);
        this.ensureBothSameNumericType(left, right, mixedNumericTypes);
        return or.executeObject(left, right);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSBitwiseOrNodeGen.create(JSBitwiseOrNode.cloneUninitialized(this.getLeft(), materializedTags), JSBitwiseOrNode.cloneUninitialized(this.getRight(), materializedTags));
    }

    public static final JSBitwiseOrNode createInner() {
        return JSBitwiseOrNodeGen.create(null, null);
    }
}

