/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.ByteBufferAccess;
import com.oracle.truffle.js.runtime.array.UnsafeByteBufferAccess;
import java.nio.ByteBuffer;

final class ReservedUnsafeByteBufferAccess
extends UnsafeByteBufferAccess {
    static final ByteBufferAccess INSTANCE = new ReservedUnsafeByteBufferAccess();

    ReservedUnsafeByteBufferAccess() {
    }

    @Override
    public int getInt16(ByteBuffer buffer, int index) {
        return Short.reverseBytes((short)super.getInt16(buffer, index));
    }

    @Override
    public int getInt32(ByteBuffer buffer, int index) {
        return Integer.reverseBytes(super.getInt32(buffer, index));
    }

    @Override
    public long getInt64(ByteBuffer buffer, int index) {
        return Long.reverseBytes(super.getInt64(buffer, index));
    }

    @Override
    public float getFloat(ByteBuffer buffer, int index) {
        return Float.intBitsToFloat(this.getInt32(buffer, index));
    }

    @Override
    public double getDouble(ByteBuffer buffer, int index) {
        return Double.longBitsToDouble(this.getInt64(buffer, index));
    }

    @Override
    public void putInt16(ByteBuffer buffer, int index, int value) {
        super.putInt16(buffer, index, Short.reverseBytes((short)value));
    }

    @Override
    public void putInt32(ByteBuffer buffer, int index, int value) {
        super.putInt32(buffer, index, Integer.reverseBytes(value));
    }

    @Override
    public void putInt64(ByteBuffer buffer, int index, long value) {
        super.putInt64(buffer, index, Long.reverseBytes(value));
    }

    @Override
    public void putFloat(ByteBuffer buffer, int index, float value) {
        this.putInt32(buffer, index, Float.floatToRawIntBits(value));
    }

    @Override
    public void putDouble(ByteBuffer buffer, int index, double value) {
        this.putInt64(buffer, index, Double.doubleToRawLongBits(value));
    }
}

