/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dnd;

import com.paterva.maltego.util.ui.dnd.MaltegoDropHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class FileDropHandler
implements MaltegoDropHandler {
    public abstract List<String> getLowercaseExtensions();

    public abstract void handleDrop(List<File> var1);

    @Override
    public boolean allowDrop(Transferable transferable) {
        return !this.getValidDropFiles(transferable).isEmpty();
    }

    @Override
    public boolean handleDrop(Transferable transferable) {
        this.handleDrop(this.getValidDropFiles(transferable));
        return true;
    }

    protected boolean isValid(File dropFile) {
        String filename = dropFile.getName().toLowerCase();
        return this.getLowercaseExtensions().stream().anyMatch(ext -> filename.endsWith("." + ext));
    }

    protected List<File> getValidDropFiles(Transferable transferable) {
        return this.getDropFiles(transferable).stream().filter(this::isValid).collect(Collectors.toList());
    }

    protected List<File> getDropFiles(Transferable transferable) {
        List files = null;
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return files != null ? files : Collections.EMPTY_LIST;
    }
}

