/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.filechooser;

import com.paterva.maltego.util.ui.components.LabelGroupWithBackground;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public final class FileChooserUtil {
    public static final String APPROVE_SELECTION_CUSTOM = "ApproveSelection_Custom";

    private FileChooserUtil() {
    }

    public static ArrayList<LabelGroupWithBackground> addAdditionalFieldsToChooser(JFileChooser chooser, String[] labels, JComponent[] components) {
        if (labels == null || components == null || labels.length == 0 || labels.length != components.length) {
            return null;
        }
        int addIndex = 3;
        ArrayList<LabelGroupWithBackground> labelGrouping = new ArrayList<LabelGroupWithBackground>();
        BorderLayout bl = (BorderLayout)chooser.getLayout();
        JPanel southPanel = (JPanel)bl.getLayoutComponent("South");
        Component[] comps = southPanel.getComponents();
        FileChooserUtil.addAdditionalFieldsToChooser(comps, southPanel, labelGrouping, labels, components, addIndex);
        LabelGroupWithBackground.groupLabels(labelGrouping.toArray(new LabelGroupWithBackground[labelGrouping.size()]));
        return labelGrouping;
    }

    public static void addAdditionalFieldsGroupToChooser(JFileChooser chooser, String title, int addIndex, ArrayList<LabelGroupWithBackground> labelGrouping, String[] labels, JComponent[] components) {
        if (labels == null || components == null || labels.length == 0 || labels.length != components.length) {
            return;
        }
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        TitledBorder border = new TitledBorder(title);
        border.setBorder(new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")));
        container.setBorder(border);
        BorderLayout bl = (BorderLayout)chooser.getLayout();
        JPanel southPanel = (JPanel)bl.getLayoutComponent("South");
        Component[] comps = southPanel.getComponents();
        Box.Filler filter = (Box.Filler)comps[1];
        filter = new Box.Filler(filter.getMinimumSize(), filter.getPreferredSize(), filter.getMaximumSize());
        southPanel.add((Component)filter, addIndex++);
        FileChooserUtil.addAdditionalFieldsToChooser(comps, container, labelGrouping, labels, components, 0);
        southPanel.add((Component)container, addIndex);
        LabelGroupWithBackground.groupLabels(labelGrouping.toArray(new LabelGroupWithBackground[labelGrouping.size()]));
    }

    private static void addAdditionalFieldsToChooser(Component[] comps, JPanel container, ArrayList<LabelGroupWithBackground> labelGrouping, String[] labels, JComponent[] components, int addIndex) {
        if (labelGrouping.isEmpty()) {
            labelGrouping.add((LabelGroupWithBackground)((JPanel)comps[0]).getComponents()[0]);
            labelGrouping.add((LabelGroupWithBackground)((JPanel)comps[2]).getComponents()[0]);
        }
        Box.Filler filter = (Box.Filler)comps[1];
        for (int i = 0; i < labels.length; ++i) {
            JPanel panel = new JPanel(new BorderLayout());
            JComponent component = components[i];
            LabelGroupWithBackground label = new LabelGroupWithBackground(labels[i]);
            labelGrouping.add(label);
            label.setLabelFor(component);
            panel.add((Component)label, "West");
            panel.add((Component)component, "Center");
            filter = new Box.Filler(filter.getMinimumSize(), filter.getPreferredSize(), filter.getMaximumSize());
            container.add((Component)filter, addIndex++);
            container.add((Component)panel, addIndex++);
        }
    }

    public static String getFileExtension(FileNameExtensionFilter fileFilter) {
        String extension = fileFilter.getExtensions()[0];
        return extension;
    }

    public static File addExtenstionIfMissing(File file, String extension) {
        if (!file.getName().toLowerCase().endsWith("." + extension.toLowerCase())) {
            file = new File(file.getPath() + "." + extension);
        }
        return file;
    }

    public static boolean mustSave(JFileChooser fileChooser) {
        boolean showError;
        File file = fileChooser.getSelectedFile();
        String error = null;
        if (file == null) {
            error = "Please choose a file name";
        } else if (!file.isDirectory()) {
            if (file.getName() == null || file.getName().trim().isEmpty()) {
                error = "Please choose a file name";
            } else {
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (fileFilter != null && fileFilter instanceof FileNameExtensionFilter) {
                    String extension = FileChooserUtil.getFileExtension((FileNameExtensionFilter)fileFilter);
                    file = FileChooserUtil.addExtenstionIfMissing(file, extension);
                }
                if (file.exists()) {
                    if (!file.canWrite()) {
                        error = "The selected file is not writable";
                    } else {
                        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)"The file already exists. Do you want to overwrite it?", "File Exists", 2);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) != NotifyDescriptor.OK_OPTION) {
                            error = "";
                        }
                    }
                } else {
                    try {
                        if (file.createNewFile()) {
                            file.delete();
                        } else {
                            error = "The directory is not writable";
                        }
                    }
                    catch (IOException ex) {
                        error = "The directory is not writable";
                    }
                }
            }
        }
        boolean bl = showError = error != null && !error.isEmpty();
        if (showError) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)error, 1));
        }
        return error == null;
    }

    public static void setDirectoryAndFile(Preferences prefs, String dirPref, JFileChooser fileChooser, String fileName) {
        String dir = prefs.get(dirPref, null);
        if (dir != null) {
            try {
                fileChooser.setCurrentDirectory(new File(dir));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        fileChooser.setSelectedFile(new File(fileName));
    }
}

