/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.http;

import com.paterva.maltego.util.http.HttpNotifier;
import com.paterva.maltego.util.ui.dialog.FailPanel;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public class ProxyFailureNotifier
extends HttpNotifier {
    private static final long MILLIS_BETWEEN_SHOWN = Duration.ofMinutes(1L).toMillis();
    private final AtomicBoolean showingDialog = new AtomicBoolean(false);
    private final AtomicBoolean dontShowAgainUntilRestart = new AtomicBoolean(false);
    private final AtomicLong lastDialogShown = new AtomicLong(0L);

    public void show(String cause) {
        if (this.showingDialog.getAndSet(true)) {
            return;
        }
        long time = System.currentTimeMillis();
        long delta = time - this.lastDialogShown.get();
        if (!this.dontShowAgainUntilRestart.get() && delta > MILLIS_BETWEEN_SHOWN) {
            this.lastDialogShown.set(time);
            UIRunQueue.instance().queue(0, "Proxy Failure Notifier", () -> this.asyncDialog(cause));
        } else {
            this.showingDialog.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncDialog(String cause) {
        JPanel outerPanel = new JPanel(new BorderLayout(12, 36));
        outerPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        FailPanel failPanel = new FailPanel("");
        failPanel.setError("Failed to proxy through " + cause);
        failPanel.setMessage("Is your proxy still running? Please adjust Options > Proxy settings accordingly.");
        failPanel.setCertificateButtonVisible(true);
        failPanel.setRetryButtonVisible(false);
        outerPanel.add((Component)failPanel, "Center");
        JCheckBox dontShowCheckbox = new JCheckBox("Don't show this again until restarting Maltego");
        outerPanel.add((Component)dontShowCheckbox, "South");
        try {
            JButton okButton = new JButton("OK");
            Object[] options = new Object[]{okButton};
            DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, "Proxy request failed", true, options, (Object)okButton, 0, HelpCtx.DEFAULT_HELP, null);
            Object chosenOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (okButton.equals(chosenOption)) {
                this.dontShowAgainUntilRestart.set(dontShowCheckbox.isSelected());
            }
        }
        finally {
            this.showingDialog.set(false);
        }
    }
}

