/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.slide;

import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.Direction;
import com.paterva.maltego.util.ui.FlatButton;
import com.paterva.maltego.util.ui.RotatedLabel;
import com.paterva.maltego.util.ui.slide.SlideWindow;
import com.paterva.maltego.util.ui.slide.SlideWindowContainer;
import com.paterva.maltego.util.ui.slide.SlideWindowManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.ImageUtilities;

class SlideWindowTab
extends JPanel {
    private Direction _direction = null;
    private RotatedLabel _viewLabel;
    private FlatButton _pinButton;
    private FlatButton _closeButton;
    private SlideWindowContainer _container;
    private transient MouseAdapter _moveListener;
    private boolean _isMoving;
    private static final int ICON_SIZE_TINY_16 = IconSize.TINY.getSize();

    public SlideWindowTab(SlideWindowContainer container, String name) {
        this.setOpaque(false);
        this.setFocusable(true);
        this._container = container;
        this._viewLabel = new RotatedLabel(name);
        this._viewLabel.setFocusable(true);
        this._viewLabel.setForeground(UIManager.getLookAndFeelDefaults().getColor("fullscreen-tab-label-color"));
        this._moveListener = new MoveListener();
        this._pinButton = this.createPinButton();
        this._closeButton = this.createCloseButton();
        this.setBorder(new TabBorder());
        this.addComponents();
    }

    public Direction getDirection() {
        return this._direction;
    }

    public void setDirection(Direction direction) {
        if (!direction.equals((Object)this._direction)) {
            this._direction = direction;
            this.directionChanged();
        }
    }

    public boolean canSlide() {
        return !this._isMoving && !this._pinButton.isSelected();
    }

    public boolean isPinned() {
        return this._pinButton.isSelected();
    }

    public void setPinned(boolean pinned) {
        this._pinButton.setSelected(pinned);
    }

    private void directionChanged() {
        this.removeAll();
        this.addComponents();
    }

    private void addComponents() {
        boolean isEast = this.isEast();
        boolean isWest = this.isWest();
        if (isEast) {
            this._viewLabel.setDirection(RotatedLabel.Direction.VERTICAL_DOWN);
        } else if (isWest) {
            this._viewLabel.setDirection(RotatedLabel.Direction.VERTICAL_UP);
        } else {
            this._viewLabel.setDirection(RotatedLabel.Direction.HORIZONTAL);
        }
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = isWest ? 2 : 0;
        this.add((Component)this._viewLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        if (isEast || isWest) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
        } else {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
        }
        this.add((Component)this._pinButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (isEast) {
            gridBagConstraints.gridy = 2;
        } else if (!isWest) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
        }
        this.add((Component)this._closeButton, gridBagConstraints);
    }

    private boolean isEast() {
        return Direction.EAST.equals((Object)this._direction);
    }

    private boolean isWest() {
        return Direction.WEST.equals((Object)this._direction);
    }

    private boolean isSouth() {
        return Direction.SOUTH.equals((Object)this._direction);
    }

    private boolean isNorth() {
        return Direction.NORTH.equals((Object)this._direction);
    }

    private FlatButton createPinButton() {
        ImageIcon normalIcon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/util/ui/slide/pin.png", (boolean)true);
        ImageIcon selectedIcon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/util/ui/slide/unpin.png", (boolean)true);
        FlatButton button = new FlatButton(normalIcon, null, new JToggleButton.ToggleButtonModel()){

            @Override
            public void paint(Graphics g) {
                if (this.getModel().isRollover()) {
                    g.setColor(new Color(0, 0, 0, 50));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(g);
            }
        };
        button.setSelectedIcon(selectedIcon);
        Dimension size = new Dimension(8 + ICON_SIZE_TINY_16, 8 + ICON_SIZE_TINY_16);
        button.setPreferredSize(size);
        button.setMinimumSize(size);
        button.setMaximumSize(size);
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setToolTipText("Pin/unpin this window");
        return button;
    }

    private FlatButton createCloseButton() {
        ImageIcon normalIcon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/util/ui/slide/close.png", (boolean)true);
        FlatButton button = new FlatButton(normalIcon, null, new JButton().getModel()){

            @Override
            public void paint(Graphics g) {
                if (this.getModel().isRollover()) {
                    g.setColor(new Color(0, 0, 0, 50));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(g);
            }
        };
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                boolean visible = false;
                SlideWindowManager.setVisiblePreference("fullscreenSlideWindowsVisible", visible);
                this.update(visible);
            }

            private void update(boolean visible) {
                List<SlideWindowContainer> all = SlideWindowManager.getDefault().getAll();
                for (SlideWindowContainer container : all) {
                    container.setVisible(visible);
                }
            }
        });
        Dimension size = new Dimension(8 + ICON_SIZE_TINY_16, 8 + ICON_SIZE_TINY_16);
        button.setPreferredSize(size);
        button.setMinimumSize(size);
        button.setMaximumSize(size);
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setToolTipText("Close Detail View");
        return button;
    }

    @Override
    public void addNotify() {
        if (this._viewLabel != null) {
            this._viewLabel.addMouseListener(this._moveListener);
            this._viewLabel.addMouseMotionListener(this._moveListener);
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        if (this._viewLabel != null) {
            this._viewLabel.removeMouseListener(this._moveListener);
            this._viewLabel.removeMouseMotionListener(this._moveListener);
        }
        super.removeNotify();
    }

    private class TabBorder
    implements Border {
        private TabBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int temp;
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            AffineTransform backupTransform = g2D.getTransform();
            if (SlideWindowTab.this.isEast()) {
                g2D.transform(AffineTransform.getQuadrantRotateInstance(1));
                g2D.translate(0, -(width - 1));
                temp = width;
                width = height;
                height = temp;
            } else if (SlideWindowTab.this.isWest()) {
                g2D.translate(0, height - 1);
                g2D.transform(AffineTransform.getQuadrantRotateInstance(-1));
                temp = width;
                width = height;
                height = temp;
            } else if (SlideWindowTab.this.isSouth()) {
                g2D.scale(1.0, -1.0);
                g2D.translate(0, -(height - 1));
            }
            SlideWindow active = SlideWindowManager.getDefault().getActive();
            boolean isActive = SlideWindowTab.this._container.getSlideWindow().equals(active);
            GeneralPath tabShape = new GeneralPath();
            int left = x;
            int right = x + 20;
            int top = y;
            int bottom = y + height - 1;
            tabShape.moveTo(left, bottom);
            tabShape.curveTo(right, bottom, left, top, right, top);
            left = x + width - 20;
            right = x + width - 1;
            top = y;
            bottom = y + height - 1;
            tabShape.lineTo(left, top);
            tabShape.curveTo(right, top, left, bottom, right, bottom);
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            g.setColor(laf.getColor(isActive ? "fullscreen-window-color" : "fullscreen-window-transparent"));
            if (SlideWindowTab.this.isWest() || SlideWindowTab.this.isNorth()) {
                left = x;
                g2D.drawLine(left, bottom, right, bottom);
            }
            g2D.fill(tabShape);
            g.setColor(laf.getColor(isActive ? "fullscreen-border-color" : "fullscreen-border-transparent"));
            g2D.draw(tabShape);
            g2D.setTransform(backupTransform);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (SlideWindowTab.this.isEast()) {
                return new Insets(20, 0, 20, 3);
            }
            if (SlideWindowTab.this.isWest()) {
                return new Insets(20, 3, 20, 0);
            }
            if (SlideWindowTab.this.isSouth()) {
                return new Insets(0, 20, 3, 20);
            }
            return new Insets(3, 20, 0, 20);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class MoveListener
    extends MouseAdapter {
        private Point _pressed;
        private Point _location;

        private MoveListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._pressed = e.getLocationOnScreen();
            this._location = SlideWindowTab.this._container.getLocation();
            SlideWindowTab.this._isMoving = true;
            SlideWindowTab.this._container.requestFocusInWindow();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(13));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point dragged = e.getLocationOnScreen();
            int dragX = dragged.x - this._pressed.x;
            int dragY = dragged.y - this._pressed.y;
            int nextX = this._location.x;
            int nextY = this._location.y;
            SlideWindowTab.this._container.setLocation(nextX += dragX, nextY += dragY);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            SlideWindowTab.this._isMoving = false;
        }
    }
}

