/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.util.ListMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.Lookup;

public abstract class TransformApiKeyProvider {
    public static synchronized TransformApiKeyProvider getDefault() {
        TransformApiKeyProvider factory = (TransformApiKeyProvider)Lookup.getDefault().lookup(TransformApiKeyProvider.class);
        if (factory == null) {
            factory = new TrivialTransformApiKeyProvider();
        }
        return factory;
    }

    public abstract String getKey(String var1);

    public static class UrlWildcard {
        private String _wildcard;
        private Pattern _hostPattern;
        private Pattern _portPattern;
        private Pattern _pathPattern;
        private static final String HOST_STAR = "[\\w\\.\\-]*";
        private static final String PORT_STAR = "[\\w\\.\\-]*";
        private static final String PATH_STAR = "[\\w\\.\\-\\\\/]*";

        public UrlWildcard(String url) {
            if (url == null) {
                throw new IllegalArgumentException("Invalid urlWildcard - cannot be null.");
            }
            String urlWildcard = UrlWildcard.stripProtocol(url);
            if (urlWildcard.startsWith("http:") || urlWildcard.startsWith("https:") || urlWildcard.startsWith("ftp:")) {
                throw new IllegalArgumentException("Invalid urlWildcard - wildcard must be specified without a protocol.");
            }
            this._wildcard = urlWildcard;
            this.parseWildcard();
        }

        private static String stripProtocol(String url) {
            int index = url.indexOf("://");
            if (index >= 0) {
                return url.substring(index + 3, url.length());
            }
            return url;
        }

        private void parseWildcard() {
            Pattern pattern = Pattern.compile("\\A[^:/\\\\]+");
            Matcher hostMatcher = pattern.matcher(this._wildcard);
            String hostRegex = "";
            if (hostMatcher.find()) {
                hostRegex = UrlWildcard.wildcardToRegex(hostMatcher.group(), "[\\w\\.\\-]*");
            }
            this._hostPattern = Pattern.compile(hostRegex);
            pattern = Pattern.compile(":[^:/\\\\]*");
            Matcher portMatcher = pattern.matcher(this._wildcard);
            String portRegex = "";
            if (portMatcher.find()) {
                String port = portMatcher.group().substring(1);
                portRegex = UrlWildcard.wildcardToRegex(port, "[\\w\\.\\-]*");
            }
            this._portPattern = Pattern.compile(portRegex);
            pattern = Pattern.compile("[/\\\\].+");
            Matcher pathMatcher = pattern.matcher(this._wildcard);
            String pathRegex = "";
            if (pathMatcher.find()) {
                String path = pathMatcher.group().substring(1);
                pathRegex = UrlWildcard.wildcardToRegex(path, PATH_STAR);
            }
            this._pathPattern = Pattern.compile(pathRegex);
        }

        private static String wildcardToRegex(String wildcard, String starReplacement) {
            Pattern literalPattern = Pattern.compile("[^\\*]+");
            Matcher literalMatcher = literalPattern.matcher(wildcard);
            StringBuffer literalBuf = new StringBuffer();
            while (literalMatcher.find()) {
                literalMatcher.appendReplacement(literalBuf, Matcher.quoteReplacement(Pattern.quote(literalMatcher.group())));
            }
            literalMatcher.appendTail(literalBuf);
            String literal = literalBuf.toString();
            literal = literal.replaceAll("\\*", Matcher.quoteReplacement(starReplacement));
            return literal;
        }

        public boolean matches(URL url) {
            return this.matchesHost(url) && this.matchesPort(url) && this.matchesPath(url);
        }

        public boolean matchesHost(URL url) {
            String host = url.getHost();
            return this._hostPattern.matcher(host).matches();
        }

        public boolean matchesPort(URL url) {
            if (this._portPattern.toString().isEmpty()) {
                return url.getPort() < 0 || url.getPort() == url.getDefaultPort();
            }
            String port = "";
            if (url.getPort() > -1) {
                port = String.valueOf(url.getPort());
            } else if (url.getDefaultPort() > -1) {
                port = String.valueOf(url.getDefaultPort());
            }
            return this._portPattern.matcher(port).matches();
        }

        public boolean matchesPath(URL url) {
            String path = url.getPath();
            if (path.length() > 0) {
                path = path.substring(1);
            }
            return this._pathPattern.matcher(path).matches();
        }

        public String getWildcard() {
            return this._wildcard;
        }

        public Pattern getHostPattern() {
            return this._hostPattern;
        }

        public Pattern getPortPattern() {
            return this._portPattern;
        }

        public Pattern getPathPattern() {
            return this._pathPattern;
        }

        public String toString() {
            return this._wildcard;
        }

        public int hashCode() {
            return this._wildcard.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UrlWildcard other = (UrlWildcard)obj;
            return !(this._wildcard == null ? other._wildcard != null : !this._wildcard.equals(other._wildcard));
        }
    }

    public static class Mapped
    extends TransformApiKeyProvider {
        private Map<UrlWildcard, String> _map;

        public static synchronized Mapped instance() {
            TransformApiKeyProvider provider = Mapped.getDefault();
            if (provider instanceof Mapped) {
                return (Mapped)provider;
            }
            return null;
        }

        @Override
        public String getKey(String target) {
            Map<UrlWildcard, String> map = this.getKeyMap();
            try {
                URL url = new URL(target);
                for (Map.Entry<UrlWildcard, String> entry : map.entrySet()) {
                    if (!entry.getKey().matches(url)) continue;
                    return entry.getValue();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return this.getDefaultKey(target);
        }

        protected Map<String, String> getDefaultMap() {
            return Collections.emptyMap();
        }

        protected String getDefaultKey(String target) {
            return null;
        }

        protected synchronized Map<UrlWildcard, String> getKeyMap() {
            if (this._map == null) {
                this.setKeyMap(this.getDefaultMap());
            }
            return this._map;
        }

        public void setKeyMap(Map<String, String> map) {
            this._map = new ListMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this._map.put(new UrlWildcard(entry.getKey()), entry.getValue());
            }
        }
    }

    private static class TrivialTransformApiKeyProvider
    extends TransformApiKeyProvider {
        private TrivialTransformApiKeyProvider() {
        }

        @Override
        public String getKey(String target) {
            return null;
        }
    }
}

