/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.EntitySpecSerializer;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.GraphMergerFactory;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;
import yguard.A.J.SA;

public class EntityMatchMergeTest
extends TopGraphAction {
    public String getName() {
        return "EntityMatchMergeTest";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void actionPerformed(TopComponent tc) {
        SlownessDetector.setEnabled((boolean)false);
        try {
            this.populateGraphWithEntities();
        }
        catch (TypeInstantiationException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void populateGraphWithEntities() throws TypeInstantiationException, IOException {
        String prefix = "com/paterva/maltego/transform/runner/impl/";
        String suffix = ".entity";
        String emptyDefault = prefix + "maltego.custom.propTest.empty.default" + suffix;
        String noDefault = prefix + "maltego.custom.propTest.no.default" + suffix;
        String spaceDefault = prefix + "maltego.custom.propTest.space.default" + suffix;
        String xDefault = prefix + "maltego.custom.propTest.x" + suffix;
        this.simulateAddingFromPalette(emptyDefault, noDefault, spaceDefault, xDefault);
        GraphView topGraph = this.getTopGraphView();
        EntityMatchMergeTest.doTransformAndMerge(topGraph, emptyDefault, "y");
        EntityMatchMergeTest.verifyResult(topGraph, emptyDefault, prefix, suffix, 4, "y");
        EntityMatchMergeTest.doTransformAndMerge(topGraph, emptyDefault, null);
        EntityMatchMergeTest.verifyResult(topGraph, emptyDefault, prefix, suffix, 4, "y");
        EntityMatchMergeTest.doTransformAndMerge(topGraph, noDefault, "y");
        EntityMatchMergeTest.verifyResult(topGraph, noDefault, prefix, suffix, 4, "y");
        EntityMatchMergeTest.doTransformAndMerge(topGraph, noDefault, null);
        EntityMatchMergeTest.verifyResult(topGraph, noDefault, prefix, suffix, 4, "y");
        EntityMatchMergeTest.doTransformAndMerge(topGraph, spaceDefault, "y");
        EntityMatchMergeTest.verifyResult(topGraph, spaceDefault, prefix, suffix, 4, "y");
        EntityMatchMergeTest.doTransformAndMerge(topGraph, spaceDefault, null);
        EntityMatchMergeTest.verifyResult(topGraph, spaceDefault, prefix, suffix, 4, " ");
        EntityMatchMergeTest.doTransformAndMerge(topGraph, xDefault, "y");
        EntityMatchMergeTest.verifyResult(topGraph, xDefault, prefix, suffix, 4, "y");
        EntityMatchMergeTest.doTransformAndMerge(topGraph, xDefault, null);
        EntityMatchMergeTest.verifyResult(topGraph, xDefault, prefix, suffix, 4, "x");
    }

    private static void verifyResult(GraphView topGraph, String entityPath, String prefix, String suffix, int count, String expectedResult) throws IOException {
        String exptectedTypeName = entityPath.replace(prefix, "").replace(suffix, "");
        GraphID graphID = GraphViewManager.getDefault().getGraphID(topGraph.getViewGraph());
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID);
        if (entities.size() != count) {
            throw new IOException("Graph should have " + count + " entities, but has " + entities.size());
        }
        boolean found = false;
        for (MaltegoEntity entity : entities) {
            String typeName = entity.getTypeName();
            if (!exptectedTypeName.equals(typeName)) continue;
            String actualResult = EntityMatchMergeTest.getProperty(entity, "prop");
            if (!expectedResult.equals(actualResult)) {
                throw new IOException("Not expected result '" + expectedResult + "', was '" + actualResult + "'");
            }
            found = true;
            break;
        }
        if (!found) {
            throw new IOException("Entity '" + exptectedTypeName + "' not found");
        }
    }

    private void simulateAddingFromPalette(String entityPath1, String entityPath2, String entityPath3, String entityPath4) throws GraphStoreException, TypeInstantiationException, XmlSerializationException {
        SA viewGraph = this.getTopViewGraph();
        GraphID graphID = GraphViewManager.getDefault().getGraphID(viewGraph);
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreWriter writer = graphStore.getGraphDataStore().getDataStoreWriter();
        writer.beginUpdate();
        viewGraph.\u00cc();
        EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
        EntityMatchMergeTest.addInitialEntity(entityPath1, entityFactory, graphID);
        EntityMatchMergeTest.addInitialEntity(entityPath2, entityFactory, graphID);
        EntityMatchMergeTest.addInitialEntity(entityPath3, entityFactory, graphID);
        EntityMatchMergeTest.addInitialEntity(entityPath4, entityFactory, graphID);
        EntityRegistry.getDefault().reloadEntities();
        System.out.println("Commiting...");
        viewGraph.D((Object)false);
        writer.endUpdate();
        viewGraph.\u00ff();
        System.out.println("Done");
    }

    private static void addInitialEntity(String filePath, EntityFactory entityFactory, GraphID graphID) throws TypeInstantiationException, XmlSerializationException {
        InputStream fis = EntityMatchMergeTest.class.getClassLoader().getResourceAsStream(filePath);
        MaltegoEntitySpec entitySpec = EntitySpecSerializer.getDefault().read(fis);
        EntityRegistry.getDefault().put((TypeSpec)entitySpec, "ManualTest");
        MaltegoEntity src = entityFactory.createInstance(entitySpec, true, true);
        GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)src);
    }

    private static void doTransformAndMerge(GraphView topGraph, String entityPath, String transformValue) throws IOException, TypeInstantiationException {
        GraphID memGraphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
        GraphStore memGraphStore = GraphStoreRegistry.getDefault().forGraphID(memGraphID);
        EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)memGraphID);
        GraphDataStoreWriter memWriter = memGraphStore.getGraphDataStore().getDataStoreWriter();
        memWriter.beginUpdate();
        InputStream fis = EntityMatchMergeTest.class.getClassLoader().getResourceAsStream(entityPath);
        MaltegoEntitySpec entitySpec = EntitySpecSerializer.getDefault().read(fis);
        MaltegoEntity dest1 = entityFactory.createInstance(entitySpec, true, true);
        String propName = "prop";
        if (transformValue != null) {
            EntityMatchMergeTest.addDymanicProperty(dest1, String.class, propName, transformValue);
        }
        GraphStoreWriter.addEntity((GraphID)memGraphID, (MaltegoEntity)dest1);
        memWriter.endUpdate();
        EntityMatchMergeTest.mergeWithTopGraph(memGraphID, topGraph);
    }

    private static void mergeWithTopGraph(GraphID memGraphID, GraphView topGraph) {
        GraphMatchStrategy matchStrat = new GraphMatchStrategy(StatelessMatchingRuleDescriptor.Default, StatelessMatchingRuleDescriptor.Default);
        GraphMergeStrategy.PreferNew mergeStrat = new GraphMergeStrategy.PreferNew();
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)memGraphID);
        String entityDescription = GraphTransactionHelper.getDescriptionForEntitiesItr((GraphID)memGraphID, (Iterable)entities, (boolean)true);
        String description = String.format("Merge test %s", entityDescription);
        GraphMerger merger = GraphMergerFactory.getDefault().create(new SimilarStrings(description), matchStrat, (GraphMergeStrategy)mergeStrat, null, true, true, true);
        GraphID destGraphID = GraphViewManager.getDefault().getGraphID(topGraph.getViewGraph());
        merger.setGraphs(destGraphID, memGraphID, null);
        merger.append();
        topGraph.doLayout();
    }

    private static void addDymanicProperty(MaltegoEntity entity, Class clazz, String propertyName, Object propertyValue) {
        PropertyDescriptor dp = new PropertyDescriptor(clazz, propertyName);
        entity.addProperty(dp);
        entity.setValue(dp, propertyValue);
    }

    private static String getProperty(MaltegoEntity entity, String propertyName) {
        PropertyDescriptorCollection props = entity.getProperties();
        PropertyDescriptor pd = props.get(propertyName);
        return (String)entity.getValue(pd);
    }
}

