/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.treelist;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.item.AbstractRunnableItem;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunningItem;
import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.favs.TransformFavorites;
import com.paterva.maltego.transform.manager.api.TransformManager;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import com.paterva.maltego.transform.runner.analytics.RunTransformEvent;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.transform.runner.api.TransformRunnable;
import com.paterva.maltego.transform.runner.api.TransformServerSelector;
import com.paterva.maltego.transform.runner.treelist.TransformRunningItem;
import com.paterva.maltego.transform.runner.treelist.TransformServerItem;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.ui.GotoUrl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;

public class TransformRunItem
extends AbstractRunnableItem {
    public static final String NAME_PREFIX = "transform.";
    private final String _transformName;
    private final Map<TransformRunnable, RunningItem> _children = new LinkedHashMap<TransformRunnable, RunningItem>();
    private Set<TransformServerInfo> _servers;
    private final String rootComponent;

    public TransformRunItem(String transformName, String rootComponent) {
        Args.notNullOrBlank((String)transformName, (String)"transformName");
        this._transformName = transformName;
        this._servers = TransformServerRegistry.getDefault().findServers(this._transformName, true);
        this.rootComponent = rootComponent;
    }

    TransformDefinition getTransform() {
        return TransformRepositoryRegistry.getDefault().findTransform(this._transformName);
    }

    public void addChild(TransformRunnable runnable) {
        this._children.put(runnable, new TransformRunningItem(runnable));
    }

    public void removeChild(TransformRunnable runnable) {
        this._children.remove(runnable);
    }

    public List<? extends RunProviderItem> getChildren() {
        this._servers = TransformServerRegistry.getDefault().findServers(this._transformName, true);
        if (this._servers.size() <= 1) {
            return new ArrayList<RunningItem>(this._children.values());
        }
        ArrayList<TransformServerItem> items = new ArrayList<TransformServerItem>(this._servers.size());
        for (TransformServerInfo server : this._servers) {
            ArrayList<RunningItem> running = new ArrayList<RunningItem>();
            for (Map.Entry<TransformRunnable, RunningItem> child : this._children.entrySet()) {
                if (!server.equals((TransformServerInfo)child.getKey().getContext().getServer().orElse(null))) continue;
                running.add(child.getValue());
            }
            items.add(new TransformServerItem(server, this._transformName, running, this.rootComponent));
        }
        return items;
    }

    public String getName() {
        return NAME_PREFIX + this._transformName;
    }

    public String getDisplayName() {
        TransformDefinition transform = this.getTransform();
        return transform != null ? transform.getDisplayName() : this._transformName;
    }

    public String getDescription() {
        TransformDefinition transform = this.getTransform();
        return transform != null ? transform.getDescription() : "";
    }

    public String getLafPrefix() {
        String prefix = "transforms-item-runnable";
        TransformDefinition transform = this.getTransform();
        if (transform != null && Status.RequiresDisclaimerAccept.equals((Object)transform.getStatus())) {
            prefix = prefix + "-disclaimer";
        }
        return prefix;
    }

    public List<Action> getToolbarActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        return actions;
    }

    public boolean canRun() {
        return this._servers.size() <= 1;
    }

    public void run(GraphID graphID, Set<EntityID> entities) {
        TransformDefinition transform;
        if (!entities.isEmpty() && (transform = this.getTransform()) != null) {
            RunTransformEvent.send(transform, this.rootComponent);
            TransformServerInfo server = TransformServerSelector.getDefault().selectServer(transform);
            TransformRequestProcessor.getDefault().runTransform(transform, server, graphID, entities, TransformRunOrigin.fromDirectRun());
        }
    }

    public boolean hasSettings() {
        return true;
    }

    public void showSettings() {
        TransformManager.getDefault().openTransform(this._transformName);
    }

    public boolean hasHelp() {
        TransformDefinition transform = this.getTransform();
        if (transform != null) {
            String helpUrl = transform.getHelpUrl();
            return FastURL.isFastURL((String)helpUrl);
        }
        return false;
    }

    public void showHelp() {
        TransformDefinition transform = this.getTransform();
        if (transform != null) {
            GotoUrl.show((String)transform.getHelpUrl());
        }
    }

    public void setFavorite(boolean favorite) {
        TransformDefinition transform = this.getTransform();
        if (transform != null) {
            TransformFavorites.getDefault().setFavorite(transform, favorite);
            this.fireItemChanged();
        }
    }

    public boolean isFavorite() {
        TransformDefinition transform = this.getTransform();
        return transform != null ? transform.isFavorite() : false;
    }

    public boolean isRememberPage() {
        return false;
    }
}

