/*
 * Decompiled with CFR 0.152.
 */
package org.phansson.netbeans.net.nbnetauthenticator;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.core.ProxySettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.NetworkSettings;
import org.openide.windows.WindowManager;
import org.phansson.netbeans.net.nbnetauthenticator.Jdk8068184Workaround;
import org.phansson.netbeans.net.nbnetauthenticator.NetAuthenticatorPanel;

public class NetAuthenticator
extends Authenticator {
    private static final Logger LOGGER = Logger.getLogger(NetAuthenticator.class.getName());
    private static final String NL = System.lineSeparator();
    private static final long TIMEOUT = 3000L;
    private static long lastTry = 0L;
    private static final String ICONRES_WARNING = "org/phansson/netbeans/net/nbnetauthenticator/warning.png";

    public NetAuthenticator() {
        Preferences proxySettingsNode = NbPreferences.root().node("/org/netbeans/core");
        assert (proxySettingsNode != null);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        LOGGER.log(Level.FINE, this.getDebugInfo());
        if (Authenticator.RequestorType.PROXY == this.getRequestorType() && ProxySettings.useAuthentication()) {
            LOGGER.log(Level.FINER, "Username set to {0} while requesting {1}", new Object[]{ProxySettings.getAuthenticationUsername(), this.getRequestingURL()});
            return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
        }
        if (System.currentTimeMillis() - lastTry > 3000L) {
            PasswordAuthentication pa;
            if (this.getRequestingProtocol().startsWith("SOCKS") && ProxySettings.getAuthenticationUsername().length() > 0) {
                return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
            }
            PasswordAuthentication auth = this.getAuthenticationFromURL();
            if (auth != null) {
                return auth;
            }
            if (NetworkSettings.isAuthenticationDialogSuppressed()) {
                return null;
            }
            if (Jdk8068184Workaround.isJDKBug(this.getRequestingScheme(), this.getRequestorType())) {
                Jdk8068184Workaround.showNotification(this.getEndpointURLString(), this.getRequestor());
                LOGGER.log(Level.WARNING, NL + NL + "*****************************************************" + NL + NL + "Your proxy is using the Negotiate auth scheme and for whatever reason " + NL + "your local Java could not obtain a Kerberos Ticket from the OS. If you " + NL + "are on Windows then you may be able to fix this by setting Registry key " + NL + "HKLM\\System\\CurrentControlSet\\Control\\Lsa\\Kerberos\\Parameters\\allowtgtsessionkey " + NL + "to 1 (=true)." + NL + NL + "Alternatively you may try setting your proxy settings manually under " + NL + "Tools --> Options --> General Tab. Press the \"More\" button and supply " + NL + "username/password explicitly." + NL + NL + "Prompting for credentials at this stage is considered dangerous because " + NL + "of JDK-8068184. Hence we fail the request for username/password and the " + NL + "network connection below will not succeed." + NL + NL + "Related debug info: " + this.getDebugInfo() + NL + NL + "*****************************************************" + NL + NL + NL);
                return null;
            }
            final Callable<PasswordAuthentication> credentialsDialogC = new Callable<PasswordAuthentication>(){

                @Override
                public PasswordAuthentication call() throws Exception {
                    return NetAuthenticator.this.getCredentialsFromDialog();
                }
            };
            Callable<FutureTask<PasswordAuthentication>> notificationCallable = new Callable<FutureTask<PasswordAuthentication>>(){

                @Override
                public FutureTask<PasswordAuthentication> call() throws Exception {
                    Notification[] notify;
                    ImageIcon icon = ImageUtilities.loadImageIcon((String)NetAuthenticator.ICONRES_WARNING, (boolean)true);
                    FutureTask<PasswordAuthentication> dialogTask = new FutureTask<PasswordAuthentication>(credentialsDialogC);
                    notify = new Notification[]{NotificationDisplayer.getDefault().notify("Authentication required", (Icon)icon, "Provide credentials", e -> {
                        try {
                            notify[0].clear();
                            dialogTask.run();
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }, NotificationDisplayer.Priority.HIGH)};
                    return dialogTask;
                }
            };
            FutureTask<FutureTask<PasswordAuthentication>> task = new FutureTask<FutureTask<PasswordAuthentication>>(notificationCallable);
            WindowManager.getDefault().invokeWhenUIReady(task);
            try {
                pa = task.get().get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                pa = null;
            }
            if (pa != null) {
                lastTry = 0L;
                return pa;
            }
            lastTry = System.currentTimeMillis();
        }
        LOGGER.log(Level.WARNING, "No authentication set while requesting " + this.getRequestingURL());
        return null;
    }

    private String getRealmName() {
        String realmName = this.getRequestingPrompt();
        if (realmName == null || realmName.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("inet");
            sb.append(this.getRequestor());
            realmName = sb.toString();
        }
        realmName = realmName.replace(':', '_').replace('.', '_');
        return realmName;
    }

    private String getDisplayMessage() {
        StringBuilder sb = new StringBuilder();
        String endpointURLStr = this.getEndpointURLString();
        if (endpointURLStr != null) {
            sb.append("While attempting to access " + endpointURLStr + " :\n");
        }
        sb.append("The ");
        if (this.getRequestorType() == Authenticator.RequestorType.SERVER) {
            sb.append("host");
        } else {
            sb.append("proxy");
        }
        sb.append(" at ");
        sb.append(this.getRequestor());
        sb.append(" is asking for credentials.");
        return sb.toString();
    }

    private String getRequestor() {
        String hostname = this.getRequestingHost();
        if (hostname == null && this.getRequestingSite() != null) {
            hostname = this.getRequestingSite().getHostAddress();
        }
        if (hostname == null) {
            hostname = "<unknown>";
        }
        return hostname + ":" + this.getRequestingPort();
    }

    private String getEndpointURLString() {
        URL endpointURL = this.getRequestingURL();
        if (endpointURL == null) {
            return "";
        }
        String urlStr = endpointURL.toString();
        int pos = urlStr.indexOf(63);
        if (pos != -1) {
            urlStr = urlStr.substring(0, pos);
        }
        return urlStr;
    }

    private PasswordAuthentication getAuthenticationFromURL() {
        String auth;
        URL u = this.getRequestingURL();
        if (u != null && (auth = u.getUserInfo()) != null) {
            int i = auth.indexOf(58);
            String user = i == -1 ? auth : auth.substring(0, i);
            String pwd = i == -1 ? "" : auth.substring(i + 1);
            return new PasswordAuthentication(user, pwd.toCharArray());
        }
        return null;
    }

    private PasswordAuthentication getCredentialsFromDialog() {
        NetAuthenticatorPanel ui = new NetAuthenticatorPanel(this.getRealmName(), this.getDisplayMessage(), this.getRequestingScheme());
        String title = NbBundle.getMessage(NetAuthenticator.class, (String)"CTL_AuthenticationDialog_Title") + (this.getRequestorType() == Authenticator.RequestorType.PROXY ? " (network proxy)" : "");
        DialogDescriptor dd = new DialogDescriptor((Object)ui, title);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            return new PasswordAuthentication(ui.getUsername(), ui.getPassword());
        }
        LOGGER.log(Level.FINER, "User pressed 'Cancel' on AuthenticatorPanel.");
        return null;
    }

    private String getDebugInfo() {
        return "Authenticator.getPasswordAuthentication() called with" + NL + "    Requested URL = " + this.getRequestingURL() + NL + "    getRequestorType()  = " + (Object)((Object)this.getRequestorType()) + NL + "    getRequestingHost()  = " + this.getRequestingHost() + NL + "    getRequestingPort()  = " + this.getRequestingPort() + NL + "    getRequestingProtocol()  = " + this.getRequestingProtocol() + NL + "    getRequestingScheme  = " + this.getRequestingScheme() + NL + "    getRequestingPrompt()  = " + this.getRequestingPrompt();
    }
}

