/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.undo;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.GraphViewUndoRedoManager;
import com.paterva.maltego.graph.undo.UndoRedoBatches;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.ui.graph.transacting.GraphTransactor;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorListener;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TransactorUndoRedoManager {
    public static final String INITIAL_GRAPH_MSG = "Initial graph sync";
    private GraphID _graphID;
    private GraphTransactorListener _transactorListener;

    public TransactorUndoRedoManager(GraphID graphID) {
        this._graphID = graphID;
    }

    public void initialize() {
        GraphTransactor transactor = this.getTransactor();
        this._transactorListener = new TransactorListener();
        transactor.addGraphTransactorListener(this._transactorListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new GraphCloseListener());
    }

    private UndoRedoModel getUndoRedo() {
        return this._graphID == null ? null : GraphViewUndoRedoManager.getDefault().get(this._graphID);
    }

    private GraphTransactor getTransactor() {
        GraphTransactor transactor = null;
        if (this._graphID != null) {
            transactor = GraphTransactorRegistry.getDefault().get(this._graphID);
        }
        return transactor;
    }

    private class GraphCloseListener
    implements PropertyChangeListener {
        private GraphCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().equals(TransactorUndoRedoManager.this._graphID)) {
                if ("graphClosing".equals(evt.getPropertyName())) {
                    GraphTransactor transactor = TransactorUndoRedoManager.this.getTransactor();
                    transactor.removeGraphTransactorListener(TransactorUndoRedoManager.this._transactorListener);
                } else if ("graphClosed".equals(evt.getPropertyName())) {
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    TransactorUndoRedoManager.this._transactorListener = null;
                    TransactorUndoRedoManager.this._graphID = null;
                }
            }
        }
    }

    private class TransactorListener
    implements GraphTransactorListener {
        private boolean _isExecuting = false;

        private TransactorListener() {
        }

        public void transactionsDone(GraphTransactionBatch batch, GraphTransactionBatch inverseBatch) {
            GraphTransactor transactor;
            UndoRedoModel undoRedo;
            if (!this._isExecuting && !TransactorUndoRedoManager.INITIAL_GRAPH_MSG.equals(batch.getDescription().getStringOne()) && (undoRedo = TransactorUndoRedoManager.this.getUndoRedo()) != null && (transactor = TransactorUndoRedoManager.this.getTransactor()) != null) {
                Integer sequenceNumber = batch.getSequenceNumber();
                batch = new GraphTransactionBatch(batch);
                inverseBatch = new GraphTransactionBatch(inverseBatch);
                batch.setSequenceNumber(null);
                inverseBatch.setSequenceNumber(null);
                TransactionCommand cmd = new TransactionCommand(transactor, batch, inverseBatch);
                undoRedo.store((Command)cmd, sequenceNumber);
            }
        }

        public class TransactionCommand
        extends Command
        implements UndoRedoBatches {
            private GraphTransactionBatch _doTransactions;
            private GraphTransactionBatch _undoTransactions;

            public TransactionCommand(GraphTransactor transactor, GraphTransactionBatch doTransactions, GraphTransactionBatch undoTransactions) {
                this._doTransactions = doTransactions;
                this._undoTransactions = undoTransactions;
            }

            @Override
            public GraphTransactionBatch getDoBatch() {
                return this._doTransactions;
            }

            @Override
            public void setDoBatch(GraphTransactionBatch batch) {
                this._doTransactions = batch;
            }

            @Override
            public GraphTransactionBatch getUndoBatch() {
                return this._undoTransactions;
            }

            @Override
            public void setUndoBatch(GraphTransactionBatch batch) {
                this._undoTransactions = batch;
            }

            public void execute() {
                this.doBatch(this._doTransactions);
            }

            public void undo() {
                this.doBatch(this._undoTransactions);
            }

            public String getDescription() {
                return this._doTransactions.getDescription().getStringOne();
            }

            public boolean isSignificant() {
                return this._doTransactions.isSignificant();
            }

            private void doBatch(GraphTransactionBatch batch) {
                TransactorListener.this._isExecuting = true;
                GraphTransactor transactor = TransactorUndoRedoManager.this.getTransactor();
                if (transactor != null) {
                    transactor.doTransactions(batch);
                }
                TransactorListener.this._isExecuting = false;
            }
        }
    }
}

